/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.core;

import io.higson.runtime.core.HigsonEngine;
import io.higson.runtime.decoder.CascadeDecoder;
import io.higson.runtime.engine.core.context.ParamContext;
import io.higson.runtime.engine.ext.FunctionInvokerInterceptor;
import io.higson.runtime.helper.TypeConverter;
import io.higson.runtime.model.Type;
import java.util.Arrays;

public class StdFunctionInterceptor
implements FunctionInvokerInterceptor {
    private final TypeConverter type = TypeConverter.getInstance();
    private final HigsonEngine engine;
    private final CascadeDecoder decoder;

    public StdFunctionInterceptor(HigsonEngine engine) {
        this.decoder = new CascadeDecoder(engine);
        this.engine = engine;
    }

    @Override
    public Object invokeFunction(String name, ParamContext ctx, Object ... args) {
        String text = name.trim();
        if (Type.isFunction(text)) {
            return this.decoder.cascadeCall(text.substring(3), ctx);
        }
        if (Type.isParameter(text)) {
            return this.cascadeToParameter(ctx, text);
        }
        if (Type.isUtilFunction(text)) {
            return this.decoder.cascadeUtilCall(text.substring(3), ctx);
        }
        if (Type.isFlow(text)) {
            return this.decoder.cascadeFlowCall(text.substring(3), ctx);
        }
        return this.engine.call(name, ctx, args);
    }

    private Object cascadeToParameter(ParamContext ctx, String text) {
        String[] cascadeResults = (String[])Arrays.stream(this.decoder.cascadeGet(text.substring(3), ctx)).map(this.type::getString).toArray(String[]::new);
        return cascadeResults.length == 1 ? cascadeResults[0] : cascadeResults;
    }
}

