/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.core.datasource.snapshot.domain;

import io.higson.runtime.core.datasource.snapshot.domain.DomainDefinitionXmlHelper;
import io.higson.runtime.core.datasource.snapshot.domain.DomainWrapper;
import io.higson.runtime.exception.ImportException;
import io.higson.runtime.helper.snapshot.SnapshotFileHelper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import pl.decerto.mpp.imports.xml.domain.DomainElement;
import pl.decerto.mpp.imports.xml.domain.DomainType;
import pl.decerto.mpp.imports.xml.domain.DomainTypeCollection;
import pl.decerto.mpp.imports.xml.domain.Reference;
import pl.decerto.mpp.imports.xml.domain.References;

public class ReferenceProcessor {
    private final SnapshotFileHelper snapshotFileHelper;
    private final DomainDefinitionXmlHelper domainDefinitionXmlHelper;

    public ReferenceProcessor(SnapshotFileHelper snapshotFileHelper, DomainDefinitionXmlHelper domainDefinitionXmlHelper) {
        this.snapshotFileHelper = snapshotFileHelper;
        this.domainDefinitionXmlHelper = domainDefinitionXmlHelper;
    }

    public void process(DomainWrapper domainWrapper, Path file) throws IOException {
        DomainElement domainElement = domainWrapper.getDomainElement();
        DomainTypeCollection domainTypeCollection = this.tryToFindDomainTypeCollectionFor(domainWrapper, file, domainElement);
        Reference referenceFromFile = this.readReferenceFromFile(file, domainTypeCollection).orElseThrow(() -> new ImportException(String.format("Path from reference.txt is missing: %s", file)));
        this.validateReferencePath(referenceFromFile, file);
        if (domainElement.getReferences() == null) {
            domainElement.setReferences(new References());
        }
        domainElement.getReferences().getReference().add(referenceFromFile);
    }

    private DomainTypeCollection tryToFindDomainTypeCollectionFor(DomainWrapper domainWrapper, Path file, DomainElement domainElement) {
        DomainType domainType = domainWrapper.getDomainType();
        Path collectionDir = file.getParent().getParent();
        String collectionCode = this.snapshotFileHelper.getDirectoryName(collectionDir);
        Optional<DomainTypeCollection> domainTypeCollection = this.domainDefinitionXmlHelper.getDomainTypeCollection(domainType, collectionCode);
        return domainTypeCollection.orElseThrow(() -> new ImportException(String.format("Missing domain type collection definition for %s in %s", domainElement.getCollectionCode(), domainType)));
    }

    private void validateReferencePath(Reference referenceFromFile, Path file) {
        String elementCodeFromPath;
        String elementReferenceName = this.snapshotFileHelper.getDirectoryName(file.getParent());
        if (!Objects.equals(elementReferenceName, elementCodeFromPath = this.retrieveCode(referenceFromFile.getPath()))) {
            throw new ImportException(String.format("Reference path element: '%s' defined in file is not the same as directory name: '%s'", elementCodeFromPath, elementReferenceName));
        }
    }

    private String retrieveCode(String fullPath) {
        return StringUtils.substringBefore((String)StringUtils.substringAfterLast((String)fullPath, (String)"["), (String)"]");
    }

    private Optional<Reference> readReferenceFromFile(Path file, DomainTypeCollection domainTypeCollection) throws IOException {
        try (Stream<String> streamLines = Files.lines(file);){
            Optional<Reference> optional = streamLines.map(line -> line + "/").map(line -> this.createReference(domainTypeCollection, (String)line)).findFirst();
            return optional;
        }
    }

    private Reference createReference(DomainTypeCollection domainTypeCollection, String line) {
        Reference reference = new Reference();
        reference.setCollectionCode(domainTypeCollection.getCode());
        reference.setCollectionTypeCode(domainTypeCollection.getCollectionTypeCode());
        reference.setPath(line);
        return reference;
    }
}

