/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.core.datasource.snapshot.function;

import com.moandjiezana.toml.Toml;
import io.higson.runtime.core.datasource.snapshot.function.FunctionAttributesModel;
import io.higson.runtime.core.datasource.snapshot.function.FunctionResult;
import io.higson.runtime.core.datasource.snapshot.function.MissingFunctionAttributeException;
import io.higson.runtime.function.FunctionType;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.translate.LookupTranslator;

public class FunctionFileExtractor {
    private static final String DEFAULT_FUNCTION_REGEX = "\\s*/\\*(.*?)\\*/\\R{0,2}(.*)";
    private static final String HASH_COMMENT_FUNCTION_REGEX = "\\s*##(.*?)##\\R{0,2}(.*)";
    private final LookupTranslator unescaper;
    private final Pattern functionDefaultPattern;
    private final Pattern functionHashedCommentPattern;

    public FunctionFileExtractor() {
        HashMap<String, String> unescapeMap = new HashMap<String, String>();
        unescapeMap.put("\\\\", "\\");
        unescapeMap.put("\\/", "/");
        this.unescaper = new LookupTranslator(unescapeMap);
        this.functionDefaultPattern = Pattern.compile(DEFAULT_FUNCTION_REGEX, 32);
        this.functionHashedCommentPattern = Pattern.compile(HASH_COMMENT_FUNCTION_REGEX, 32);
    }

    public FunctionResult readAttributesFromMatcher(Path file) throws IOException {
        String body = this.readStringFromFile(file);
        Matcher matcher = this.functionDefaultPattern.matcher(body);
        if (this.isMatcherForArgumentsNotQualified(matcher) && this.isMatcherForArgumentsNotQualified(matcher = this.functionHashedCommentPattern.matcher(body))) {
            throw new MissingFunctionAttributeException(file.toString());
        }
        FunctionAttributesModel attributes = this.readAttributesFromMatcher(matcher);
        String impl = matcher.group(2);
        return new FunctionResult(attributes, impl, FunctionFileExtractor.getExtension(file));
    }

    private static FunctionType getExtension(Path file) {
        String extension;
        return switch (extension = FilenameUtils.getExtension((String)file.toString())) {
            case "groovy" -> FunctionType.GROOVY;
            case "py" -> FunctionType.PYTHON;
            case "js" -> FunctionType.RHINO;
            default -> null;
        };
    }

    private FunctionAttributesModel readAttributesFromMatcher(Matcher matcher) {
        return (FunctionAttributesModel)new Toml().read(this.unescaper.translate((CharSequence)this.getCommentedAttributesFrom(matcher))).to(FunctionAttributesModel.class);
    }

    private String getCommentedAttributesFrom(Matcher matcher) {
        if (Objects.equals(this.functionHashedCommentPattern, matcher.pattern())) {
            String tmpBody = StringUtils.substringAfter((String)matcher.group(1), (String)"# categories").replaceAll("#\\s", "");
            return "categories" + tmpBody;
        }
        String commentedPart = matcher.group(1);
        return commentedPart;
    }

    private boolean isMatcherForArgumentsNotQualified(Matcher matcher) {
        return !matcher.matches() || matcher.groupCount() != 2;
    }

    private String readStringFromFile(Path file) throws IOException {
        byte[] encoded = Files.readAllBytes(file);
        return new String(encoded, StandardCharsets.UTF_8);
    }
}

