/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.core.datasource.snapshot.function;

import io.higson.runtime.core.datasource.FunctionDao;
import io.higson.runtime.core.datasource.VersionDao;
import io.higson.runtime.core.datasource.snapshot.function.FunctionArgumentModel;
import io.higson.runtime.core.datasource.snapshot.function.FunctionDetails;
import io.higson.runtime.core.datasource.snapshot.function.FunctionMeta;
import io.higson.runtime.core.datasource.snapshot.function.SnapshotFunctionReader;
import io.higson.runtime.core.datasource.snapshot.helper.SnapshotDataSourceConstants;
import io.higson.runtime.function.FunctionType;
import io.higson.runtime.function.log.FunctionLogLevel;
import io.higson.runtime.model.Function;
import io.higson.runtime.model.GroovyFunction;
import io.higson.runtime.model.PythonFunction;
import io.higson.runtime.model.RegionVersion;
import io.higson.runtime.model.RhinoFunction;
import io.higson.runtime.sync.Trackable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotFunctionDao
implements FunctionDao {
    private static final Logger log = LoggerFactory.getLogger(SnapshotFunctionDao.class);
    private static final String ARGUMENTS_DELIMITER = ",";
    private final SnapshotFunctionReader snapshotFileReader;
    private final VersionDao versionDao;

    @Override
    public Function getFunction(String code, String ver, int sid) {
        FunctionDetails functionDetails = this.snapshotFileReader.getFunction(code, ver, this.versionDao.getAllSchedules());
        return this.buildFunction(functionDetails);
    }

    @Override
    public Date getMaxLastUpdate() {
        return SnapshotDataSourceConstants.YEAR_AGO;
    }

    @Override
    public List<Trackable> getAllLastUpdates() {
        return Collections.emptyList();
    }

    @Override
    public List<Function> getAllHeads() {
        Map<Integer, RegionVersion> versions = this.versionDao.getAllRegionVersions();
        return this.snapshotFileReader.getFunctionsMeta().values().stream().map(functionMeta -> this.buildBasicFunction((FunctionMeta)functionMeta, versions)).toList();
    }

    @Override
    public List<String> getArgumentsForFunction(String functionCode) {
        return Arrays.stream(this.getFunction(functionCode, null, 0).getArgs().split(ARGUMENTS_DELIMITER)).toList();
    }

    private Function buildBasicFunction(FunctionMeta functionMeta, Map<Integer, RegionVersion> allRegionVersions) {
        return new Function(functionMeta.id(), functionMeta.implId(), functionMeta.code(), functionMeta.type().name(), SnapshotDataSourceConstants.YEAR_AGO, this.getVersionId(functionMeta, allRegionVersions), FunctionLogLevel.INFO);
    }

    private Function buildFunction(FunctionDetails functionDetails) {
        Function function = switch (functionDetails.type()) {
            case FunctionType.RHINO -> new RhinoFunction(functionDetails.id(), functionDetails.implId(), functionDetails.code(), SnapshotFunctionDao.getArguments(functionDetails), functionDetails.body(), SnapshotDataSourceConstants.YEAR_AGO, functionDetails.logLevel());
            case FunctionType.PYTHON -> new PythonFunction(functionDetails.id(), functionDetails.implId(), functionDetails.code(), SnapshotFunctionDao.getArguments(functionDetails), functionDetails.body(), SnapshotDataSourceConstants.YEAR_AGO, functionDetails.logLevel());
            case FunctionType.GROOVY -> new GroovyFunction(functionDetails.id(), functionDetails.implId(), functionDetails.code(), SnapshotFunctionDao.getArguments(functionDetails), functionDetails.body(), SnapshotDataSourceConstants.YEAR_AGO, functionDetails.logLevel());
            default -> throw new UnsupportedOperationException(functionDetails.type().toString());
        };
        function.setArgumentToType(this.getArgumentsWithType(functionDetails));
        return function;
    }

    private Map<String, String> getArgumentsWithType(FunctionDetails functionDetails) {
        return functionDetails.arguments().stream().collect(Collectors.toMap(FunctionArgumentModel::getName, FunctionArgumentModel::getType));
    }

    private static String getArguments(FunctionDetails functionDetails) {
        return functionDetails.arguments().stream().map(FunctionArgumentModel::getName).collect(Collectors.joining(ARGUMENTS_DELIMITER));
    }

    private int getVersionId(FunctionMeta functionMeta, Map<Integer, RegionVersion> allRegionVersions) {
        if (functionMeta.version() != null) {
            Optional<RegionVersion> version = allRegionVersions.values().stream().filter(rv -> Objects.equals(rv.getRegion(), functionMeta.region()) && Objects.equals(rv.getNumber(), functionMeta.version()) && Objects.equals(rv.getProfileCode(), functionMeta.profile())).findAny();
            if (version.isPresent()) {
                return version.get().getId();
            }
            log.warn("Cannot find function ({}.{},{}) version in all snapshot versions", new Object[]{functionMeta.profile(), functionMeta.region(), functionMeta.version()});
        }
        return 0;
    }

    public SnapshotFunctionDao(SnapshotFunctionReader snapshotFileReader, VersionDao versionDao) {
        this.snapshotFileReader = snapshotFileReader;
        this.versionDao = versionDao;
    }
}

