/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.core.datasource.snapshot.parameter;

import io.higson.runtime.alias.LevelMapper;
import io.higson.runtime.core.datasource.snapshot.IncorrectSnapshotException;
import io.higson.runtime.core.datasource.snapshot.SnapshotPath;
import io.higson.runtime.core.datasource.snapshot.helper.SnapshotDirHelper;
import io.higson.runtime.core.datasource.snapshot.parameter.ParameterDetails;
import io.higson.runtime.core.datasource.snapshot.parameter.ParameterDetailsInputLevel;
import io.higson.runtime.core.datasource.snapshot.parameter.ParameterDetailsOutputLevel;
import io.higson.runtime.core.datasource.snapshot.parameter.ParameterFileExtractor;
import io.higson.runtime.core.datasource.snapshot.parameter.ParameterInputLevelModel;
import io.higson.runtime.core.datasource.snapshot.parameter.ParameterMeta;
import io.higson.runtime.core.datasource.snapshot.parameter.ParameterModel;
import io.higson.runtime.core.datasource.snapshot.parameter.ParameterNotFoundInSnapshotException;
import io.higson.runtime.core.datasource.snapshot.parameter.ParameterOutputLevelModel;
import io.higson.runtime.core.datasource.snapshot.reader.SnapshotReader;
import io.higson.runtime.engine.core.parameter.MatchMode;
import io.higson.runtime.engine.core.parameter.ParameterEntry;
import io.higson.runtime.helper.MpHelper;
import io.higson.runtime.model.MpParameterEntry;
import io.higson.runtime.model.region.ScheduleContainer;
import jakarta.annotation.Nullable;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotParameterReader {
    private static final Logger log = LoggerFactory.getLogger(SnapshotParameterReader.class);
    private static final String VERSION_SEPARATOR = ":";
    private static final String MATRIX_VALUES_SEPARATOR = ";";
    private static final String PARAMETER_DEF_EXTENSION = "def";
    private static final String PARAMETER_MATRIX_EXTENSION = "mat";
    private static final String LEVEL_PROPERTY = "prop:";
    private final MpHelper mpHelper = new MpHelper();
    private final File snapDir;
    private final SnapshotReader snapshotReader;
    private final AtomicInteger paramIdGenerator = new AtomicInteger(1);
    private final AtomicInteger levelIdGenerator = new AtomicInteger(1);
    private boolean loaded = false;
    private final Map<String, ParameterMeta> parametersMeta = new HashMap<String, ParameterMeta>();

    public ParameterDetails getParameterDetails(String code, String version, Map<String, ScheduleContainer> allSchedules) {
        this.loadParametersMeta();
        AtomicInteger orderNrGenerator = new AtomicInteger(1);
        ParameterMeta parameterMeta = this.findParameterMeta(code, version, allSchedules);
        ParameterModel model = ParameterFileExtractor.getParameterFromFile(parameterMeta.path());
        return ParameterDetails.builder().id(parameterMeta.id()).code(model.getCode()).profile(parameterMeta.profile()).region(parameterMeta.region()).version(parameterMeta.version()).description(model.getDescription()).nullable(model.isNullable()).dictionary(model.isDictionary()).cacheable(model.isCacheable()).distinct(model.isDistinct()).sort(model.getSort()).masterName(model.getMasterName()).externalSource(model.getExternalSource()).slave(model.isSlave()).label(model.getLabel()).categories(model.getCategories()).inputLevels(this.buildInputLevels(model.getInputLevel(), orderNrGenerator)).outputLevels(this.buildOutputLevels(model.getOutputLevel(), orderNrGenerator)).build();
    }

    public List<ParameterEntry> getEntries(int id, Map<String, ScheduleContainer> allSchedules) {
        return this.getEntries(id, null, allSchedules);
    }

    public List<ParameterEntry> getEntries(int id, LevelMapper mapper, Map<String, ScheduleContainer> allSchedules) {
        List<ParameterEntry> list;
        block8: {
            this.loadParametersMeta();
            Path matrixPath = this.getMatrixPath(id, allSchedules);
            Reader reader = this.snapshotReader.getReader(this.snapDir, matrixPath);
            try {
                list = this.readMatrix(reader, mapper);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            reader.close();
        }
        return list;
    }

    public Map<String, ParameterMeta> getParametersMeta() {
        this.loadParametersMeta();
        return this.parametersMeta;
    }

    private Path getMatrixPath(int id, Map<String, ScheduleContainer> allSchedules) {
        ParameterMeta parameterMeta = this.findParameterMeta(id);
        ParameterDetails parameterDetails = this.getParameterDetails(parameterMeta.code(), parameterMeta.version(), allSchedules);
        if (parameterDetails.slave()) {
            ParameterMeta masterMeta = this.findParameterMeta(parameterDetails.masterName(), parameterDetails.version(), allSchedules);
            return this.getMatrixPath(masterMeta);
        }
        return this.getMatrixPath(parameterMeta);
    }

    private List<ParameterDetailsOutputLevel> buildOutputLevels(List<ParameterOutputLevelModel> outputLevel, AtomicInteger orderNoGenerator) {
        return outputLevel.stream().map(level -> ParameterDetailsOutputLevel.builder().id(this.levelIdGenerator.getAndIncrement()).orderNo(orderNoGenerator.getAndIncrement()).name(level.getCode()).type(level.getType()).array(level.isArray()).external(level.isExternal()).build()).toList();
    }

    private List<ParameterDetailsInputLevel> buildInputLevels(List<ParameterInputLevelModel> levels, AtomicInteger orderNoGenerator) {
        return levels.stream().map(level -> ParameterDetailsInputLevel.builder().id(this.levelIdGenerator.getAndIncrement()).orderNr(orderNoGenerator.getAndIncrement()).name(level.getCode()).type(level.getType()).matcher(level.getMatcher()).reverseMatcher(level.isReverseMatcher()).matchMode(level.isUnion() ? MatchMode.UNION : MatchMode.STANDARD).levelCreator(this.createLevelCreator((ParameterInputLevelModel)level)).build()).toList();
    }

    private String createLevelCreator(ParameterInputLevelModel level) {
        if (level.getLevelCreator() != null) {
            return level.getLevelCreator();
        }
        if (level.getProperty() != null) {
            return LEVEL_PROPERTY + level.getProperty();
        }
        return null;
    }

    private List<ParameterEntry> readMatrix(Reader reader, LevelMapper mapper) {
        ArrayList<ParameterEntry> entries = new ArrayList<ParameterEntry>();
        BufferedReader bufferedReader = new BufferedReader(reader);
        try {
            while (bufferedReader.ready()) {
                String line = bufferedReader.readLine();
                String[] values = line.split(MATRIX_VALUES_SEPARATOR);
                this.mpHelper.unify(values);
                entries.add(this.createParameterEntry(values, mapper));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        SnapshotParameterReader.cleanMatrix(entries);
        return entries;
    }

    private MpParameterEntry createParameterEntry(String[] values, LevelMapper mapper) {
        if (mapper != null && mapper.isNotIdentical()) {
            return this.mpHelper.createEntry(mapper, values);
        }
        return new MpParameterEntry(values);
    }

    private static void cleanMatrix(List<ParameterEntry> entries) {
        if (entries.size() > 1) {
            Object[] commentRow = entries.remove(0).getLevels();
            log.debug("Matrix csv - removing expected comment line: {}", (Object)Arrays.toString(commentRow));
            Object[] labelsRow = entries.remove(0).getLevels();
            log.debug("Matrix csv - removing expected labels line: {}", (Object)Arrays.toString(labelsRow));
        }
    }

    private Path getMatrixPath(ParameterMeta parameterMeta) {
        return Path.of(parameterMeta.relativeSnapshotPath().getParent().toString(), FilenameUtils.getBaseName((String)parameterMeta.relativeSnapshotPath().toString()) + ".mat");
    }

    private void loadParametersMeta() {
        if (!this.loaded) {
            try (Stream<Path> pathStream = Files.walk(this.snapshotReader.getPath(this.snapDir.toPath(), SnapshotPath.PARAMS.getPath()), new FileVisitOption[0]);){
                pathStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(this::hasDefExtension).forEach(this.add());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (this.parametersMeta.isEmpty()) {
                log.warn("Cannot find functions in snapshot {}", (Object)this.snapDir.toPath());
            }
            this.loaded = true;
        }
    }

    private ParameterMeta findParameterMeta(String code, String version, Map<String, ScheduleContainer> allSchedules) {
        ParameterMeta parameterMeta = this.parametersMeta.get(this.parameterUid(code, version));
        if (parameterMeta == null && version == null) {
            return this.getParameterFromAppropriateVersion(code, allSchedules);
        }
        if (parameterMeta == null) {
            throw new ParameterNotFoundInSnapshotException(code, version, this.snapDir.getPath());
        }
        return parameterMeta;
    }

    private ParameterMeta getParameterFromAppropriateVersion(String code, Map<String, ScheduleContainer> allSchedules) {
        List<ParameterMeta> params = this.findParameterInAllVersions(code);
        if (params.isEmpty()) {
            throw new ParameterNotFoundInSnapshotException(code, null, this.snapDir.getPath());
        }
        if (allSchedules == null) {
            return this.getInHighestVersion(params);
        }
        ParameterMeta paramInVersion = params.get(0);
        String profile = paramInVersion.profile();
        ScheduleContainer scheduleContainer = allSchedules.get(profile);
        if (scheduleContainer == null) {
            return this.getInHighestVersion(params);
        }
        return scheduleContainer.getSchedule(paramInVersion.region()).map(value -> value.find(new Date()).map(entry -> params.stream().filter(parameterMeta -> parameterMeta.version().equals(entry.getVersion())).findAny().orElseGet(() -> this.getInHighestVersion(params))).orElseGet(() -> this.getInHighestVersion(params))).orElseGet(() -> this.getInHighestVersion(params));
    }

    private ParameterMeta getInHighestVersion(List<ParameterMeta> params) {
        return params.stream().max(Comparator.comparingInt(p -> Integer.parseInt(p.version()))).get();
    }

    private List<ParameterMeta> findParameterInAllVersions(String code) {
        return this.parametersMeta.entrySet().stream().filter(t -> ((String)t.getKey()).startsWith(code + VERSION_SEPARATOR)).map(Map.Entry::getValue).toList();
    }

    private ParameterMeta findParameterMeta(int id) {
        return this.parametersMeta.values().stream().filter(param -> param.id() == id).findAny().orElseThrow(() -> new IllegalStateException("Cannot find parameter with id " + id));
    }

    private boolean hasDefExtension(Path path) {
        return FilenameUtils.getExtension((String)path.toString()).equals(PARAMETER_DEF_EXTENSION);
    }

    private Consumer<? super Path> add() {
        return new Consumer<Path>(){

            @Override
            public void accept(Path path) {
                String[] segments = this.getSegments(path);
                String version = SnapshotDirHelper.getVersion(path, segments);
                String code = SnapshotDirHelper.getFullCode(path, segments, version);
                ParameterMeta parameterMeta = ParameterMeta.builder().profile(SnapshotDirHelper.getProfile(path, segments)).region(SnapshotDirHelper.getRegion(path, segments)).version(version).code(code).path(path).relativeSnapshotPath(this.relativeSnapshotPath(path)).id(SnapshotParameterReader.this.paramIdGenerator.incrementAndGet()).build();
                this.addParameterMeta(code, version, parameterMeta);
            }

            private Path relativeSnapshotPath(Path path) {
                String snapString = SnapshotParameterReader.this.snapDir.toPath().toString();
                String pathString = path.toString();
                if (pathString.startsWith(snapString)) {
                    return Path.of(StringUtils.remove((String)pathString, (String)snapString), new String[0]);
                }
                return path;
            }

            private String[] getSegments(Path path) {
                String[] segments = path.toString().split("[/\\\\]");
                if (segments.length == 0) {
                    throw new IncorrectSnapshotException("Incorrect snapshot path " + path);
                }
                return segments;
            }

            private void addParameterMeta(String code, String version, ParameterMeta parameterMeta) {
                String parameterUid = SnapshotParameterReader.this.parameterUid(code, version);
                if (SnapshotParameterReader.this.parametersMeta.containsKey(parameterUid)) {
                    throw new IncorrectSnapshotException("Snapshot contains two parameters with same name " + parameterUid);
                }
                SnapshotParameterReader.this.parametersMeta.put(parameterUid, parameterMeta);
            }
        };
    }

    private String parameterUid(String code, @Nullable String version) {
        return version == null ? code : code + VERSION_SEPARATOR + version;
    }

    public SnapshotParameterReader(File snapDir, SnapshotReader snapshotReader) {
        this.snapDir = snapDir;
        this.snapshotReader = snapshotReader;
    }
}

