/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.core.datasource.snapshot.version;

import com.google.common.base.Preconditions;
import io.higson.runtime.core.datasource.snapshot.IncorrectSnapshotException;
import io.higson.runtime.core.datasource.snapshot.SnapshotPath;
import io.higson.runtime.core.datasource.snapshot.reader.SnapshotReader;
import io.higson.runtime.core.datasource.snapshot.version.RegionScheduleModel;
import io.higson.runtime.core.datasource.snapshot.version.ScheduleDetails;
import io.higson.runtime.core.datasource.snapshot.version.VersionMeta;
import io.higson.runtime.helper.snapshot.CsvUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.file.PathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotVersionsReader {
    private static final Logger log = LoggerFactory.getLogger(SnapshotVersionsReader.class);
    private static final String VERSION_EXTENSION = "ver";
    private static final String SCHEDULE_EXTENSION = "csv";
    private static final String SCHEDULE_PREFIX = "schedule_";
    private final CsvUtils csvUtils = new CsvUtils();
    private final AtomicInteger regionId = new AtomicInteger(1);
    private final AtomicInteger versionId = new AtomicInteger(1);
    private boolean loaded = false;
    private final List<VersionMeta> versions = new ArrayList<VersionMeta>();
    private final Map<String, Map<String, Integer>> profilesToRegions = new HashMap<String, Map<String, Integer>>();
    private final List<ScheduleDetails> schedule = new ArrayList<ScheduleDetails>();
    private final File snapDir;
    private final SnapshotReader snapshotReader;

    public List<VersionMeta> getVersions() {
        this.load();
        return this.versions;
    }

    public List<ScheduleDetails> getSchedule() {
        this.load();
        return this.schedule;
    }

    private void load() {
        if (!this.loaded) {
            this.loadVersions();
            this.loadSchedule();
            this.loaded = true;
        }
    }

    private void loadSchedule() {
        if (!this.profilesDirExists()) {
            log.debug("profiles directory not found");
            return;
        }
        try (Stream<Path> stream = Files.walk(this.snapshotReader.getPath(this.snapDir.toPath(), SnapshotPath.PROFILES.getPath()), new FileVisitOption[0]);){
            stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> PathUtils.getExtension((Path)path).equals(SCHEDULE_EXTENSION)).filter(path -> FilenameUtils.getBaseName((String)path.toString()).startsWith(SCHEDULE_PREFIX)).forEach(this.addSchedule());
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot read schedule in snapshot", e);
        }
    }

    private void loadVersions() {
        if (!this.profilesDirExists()) {
            log.debug("profiles directory not found");
            return;
        }
        try (Stream<Path> stream = Files.walk(this.snapshotReader.getPath(this.snapDir.toPath(), SnapshotPath.PROFILES.getPath()), new FileVisitOption[0]);){
            stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> PathUtils.getExtension((Path)path).equals(VERSION_EXTENSION)).forEach(this.addVersion());
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot read versions in snapshot", e);
        }
    }

    private Consumer<? super Path> addVersion() {
        return path -> {
            SnapshotVersionsReader.validatePath(path);
            this.versions.add(this.buildVersionMeta((Path)path));
        };
    }

    private Consumer<? super Path> addSchedule() {
        return path -> {
            SnapshotVersionsReader.validateSchedulePath(path);
            this.schedule.addAll(this.buildScheduleDetails((Path)path));
        };
    }

    private List<ScheduleDetails> buildScheduleDetails(Path path) {
        Path regionDir = path.getParent();
        Preconditions.checkArgument((boolean)regionDir.getParent().getFileName().toString().equals(SnapshotPath.REGIONS.getPath()), (Object)(SnapshotPath.REGIONS.getPath() + " dir expected."));
        String region = regionDir.getFileName().toString();
        String profile = regionDir.getParent().getParent().getFileName().toString();
        List<RegionScheduleModel> scheduleModels = this.readScheduleFile(path);
        return scheduleModels.stream().map(p -> ScheduleDetails.builder().profile(profile).region(region).version(p.getNumber()).validFrom(p.getValidFrom()).validTo(p.getValidTo()).build()).toList();
    }

    private List<RegionScheduleModel> readScheduleFile(Path path) {
        try {
            return this.csvUtils.parse(path, RegionScheduleModel.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void validatePath(Path path) {
        if (path.toString().split("[/\\\\]").length < 6) {
            throw new IncorrectSnapshotException("Cannot read versions - incorrect snapshot @profiles dir. Expected path: @profiles/PROFILE_NAME/@regions/REGION_NAME/@versions/VERSION_NAME.ver");
        }
    }

    private static void validateSchedulePath(Path path) {
        if (path.toString().split("[/\\\\]").length < 5) {
            throw new IncorrectSnapshotException("Cannot read schedule - incorrect snapshot @profiles dir. Expected path: @profiles/PROFILE_NAME/@regions/REGION_NAME/schedule_REGION_NAME.csv");
        }
    }

    private VersionMeta buildVersionMeta(Path path) {
        Path regionDir = path.getParent().getParent();
        Preconditions.checkArgument((boolean)regionDir.getParent().getFileName().toString().equals(SnapshotPath.REGIONS.getPath()), (Object)(SnapshotPath.REGIONS.getPath() + " dir expected."));
        Preconditions.checkArgument((boolean)path.getParent().getFileName().toString().equals(SnapshotPath.VERSIONS.getPath()), (Object)(SnapshotPath.VERSIONS.getPath() + " dir expected."));
        String region = regionDir.getFileName().toString();
        String profile = regionDir.getParent().getParent().getFileName().toString();
        String version = FilenameUtils.getBaseName((String)path.getFileName().toString());
        return VersionMeta.builder().version(version).region(region).profile(profile).regionId(this.getRegionId(profile, region)).versionId(this.versionId.getAndIncrement()).build();
    }

    private int getRegionId(String profile, final String region) {
        if (this.profilesToRegions.containsKey(profile)) {
            return this.profilesToRegions.get(profile).computeIfAbsent(region, i -> this.regionId.getAndIncrement());
        }
        final int regionId = this.regionId.getAndIncrement();
        this.profilesToRegions.put(profile, (Map<String, Integer>)new HashMap<String, Integer>(){
            {
                this.put(region, regionId);
            }
        });
        return regionId;
    }

    private boolean profilesDirExists() {
        Path root = this.snapDir.toPath();
        Path profiles = Path.of(SnapshotPath.PROFILES.getPath(), new String[0]);
        return this.snapshotReader.exists(root, profiles);
    }

    public SnapshotVersionsReader(File snapDir, SnapshotReader snapshotReader) {
        this.snapDir = snapDir;
        this.snapshotReader = snapshotReader;
    }
}

