/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.engine.core.prepared;

import io.higson.runtime.engine.core.decoder.StandardDecoder;
import io.higson.runtime.engine.core.decoder.ValueDecoder;
import io.higson.runtime.engine.core.function.Function;
import io.higson.runtime.engine.core.matcher.Matcher;
import io.higson.runtime.engine.core.matcher.MatcherRepository;
import io.higson.runtime.engine.core.parameter.BasicParameterProvider;
import io.higson.runtime.engine.core.parameter.Level;
import io.higson.runtime.engine.core.parameter.Parameter;
import io.higson.runtime.engine.core.prepared.LevelPreparer;
import io.higson.runtime.engine.core.prepared.PreparedLevel;
import io.higson.runtime.engine.core.prepared.UnknownMatcherException;
import io.higson.runtime.engine.core.prepared.UnknownTypeException;
import io.higson.runtime.engine.core.type.Type;
import io.higson.runtime.engine.core.type.TypeRepository;
import io.higson.runtime.engine.core.type.ValueHolder;

public class BasicLevelPreparer
implements LevelPreparer {
    private final MatcherRepository matcherRepository;
    private final TypeRepository typeRepository;
    private final BasicParameterProvider parameterProvider;

    @Override
    public PreparedLevel prepare(Level level) {
        Type<? extends ValueHolder> type = this.resolveType(level.getType(), level.getName());
        Matcher matcher = this.resolveMatcher(level.getMatcher(), level.getName(), level.isReverseMatcher());
        Function levelCreator = this.createFunctionStub(level.getLevelCreator());
        ValueDecoder decoder = level.getValueDecoder() != null ? level.getValueDecoder() : new StandardDecoder();
        return new PreparedLevel(level.getName(), level.isArray(), type, matcher, levelCreator, level.getMatchMode(), decoder);
    }

    private Type<? extends ValueHolder> resolveType(String typeCode, String levelName) {
        if (typeCode == null) {
            return null;
        }
        Type<? extends ValueHolder> type = this.typeRepository.getType(typeCode);
        return type != null ? type : this.tryResolveByDictionaryType(levelName, typeCode);
    }

    private Type<? extends ValueHolder> tryResolveByDictionaryType(String levelName, String dictionaryName) {
        String type;
        Parameter parameter = this.parameterProvider.load(dictionaryName);
        try {
            type = parameter.getLevels().get(0).getType();
        }
        catch (Exception exp) {
            throw new UnknownTypeException(levelName, dictionaryName);
        }
        return this.typeRepository.getType(type);
    }

    private Matcher resolveMatcher(String matcherCode, String levelName, boolean reverseMatcher) {
        Matcher matcher = null;
        if (matcherCode != null) {
            matcher = this.matcherRepository.getMatcher(matcherCode);
            if (matcher == null) {
                throw new UnknownMatcherException(levelName, matcherCode);
            }
            matcher.setReverse(reverseMatcher);
        }
        return matcher;
    }

    private Function createFunctionStub(String levelCreatorCode) {
        if (levelCreatorCode != null) {
            return new Function(levelCreatorCode, null);
        }
        return null;
    }

    public BasicLevelPreparer(MatcherRepository matcherRepository, TypeRepository typeRepository, BasicParameterProvider parameterProvider) {
        this.matcherRepository = matcherRepository;
        this.typeRepository = typeRepository;
        this.parameterProvider = parameterProvider;
    }
}

