/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.engine.core.prepared;

import io.higson.runtime.core.Properties;
import io.higson.runtime.core.PropertiesAware;
import io.higson.runtime.engine.core.index.LevelIndex;
import io.higson.runtime.engine.core.matcher.Matcher;
import io.higson.runtime.engine.core.parameter.Level;
import io.higson.runtime.engine.core.parameter.MatchMode;
import io.higson.runtime.engine.core.parameter.Parameter;
import io.higson.runtime.engine.core.parameter.ParameterEntry;
import io.higson.runtime.engine.core.parameter.ParameterProvider;
import io.higson.runtime.engine.core.prepared.CacheEntry;
import io.higson.runtime.engine.core.prepared.InputValueNormalizer;
import io.higson.runtime.engine.core.prepared.LevelPreparer;
import io.higson.runtime.engine.core.prepared.ParamPreparer;
import io.higson.runtime.engine.core.prepared.PreparedEntry;
import io.higson.runtime.engine.core.prepared.PreparedLevel;
import io.higson.runtime.engine.core.prepared.PreparedOutput;
import io.higson.runtime.engine.core.prepared.PreparedParamCache;
import io.higson.runtime.engine.core.prepared.PreparedParameter;
import io.higson.runtime.engine.core.type.Type;
import io.higson.runtime.evict.IdleChecker;
import io.higson.runtime.evict.NopIdleChecker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicParamPreparer
implements ParamPreparer,
PropertiesAware {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ParameterProvider parameterProvider;
    private final LevelPreparer levelPreparer;
    private final PreparedParamCache cache;
    private final ConcurrentMap<String, ReentrantLock> locks = new ConcurrentHashMap<String, ReentrantLock>();
    private boolean fastReturnForLoad = true;
    private Properties properties;
    private IdleChecker idleChecker = NopIdleChecker.getInstance();

    public BasicParamPreparer(ParameterProvider parameterProvider, LevelPreparer levelPreparer, PreparedParamCache cache) {
        this.parameterProvider = parameterProvider;
        this.levelPreparer = levelPreparer;
        this.cache = cache;
    }

    @Override
    public PreparedParameter getPreparedParameter(String paramName) {
        PreparedParameter pp = this.cache.get(paramName);
        if (pp == null) {
            pp = this.load(paramName);
        }
        return pp;
    }

    private ReentrantLock getMutex(String name) {
        ReentrantLock mutex = new ReentrantLock();
        ReentrantLock prev = this.locks.putIfAbsent(name, mutex);
        if (prev != null) {
            return prev;
        }
        return mutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreparedParameter load(String name) {
        ReentrantLock mutex = this.getMutex(name);
        this.log.trace("obtaining lock for [{}] / {} ", (Object)name, (Object)mutex);
        mutex.lock();
        this.log.trace("obtained: [{}]", (Object)name);
        try {
            PreparedParameter pp = this.cache.get(name);
            if (pp != null && this.isFastReturnForLoad()) {
                this.log.trace("found in cache, fast return: {}", (Object)name);
                PreparedParameter preparedParameter = pp;
                return preparedParameter;
            }
            Parameter parameter = this.parameterProvider.load(name);
            if (parameter == null) {
                PreparedParameter preparedParameter = null;
                return preparedParameter;
            }
            pp = this.prepare(parameter);
            this.cache.put(name, pp);
            PreparedParameter preparedParameter = pp;
            return preparedParameter;
        }
        finally {
            mutex.unlock();
            this.log.trace("unlocked: [{}]", (Object)name);
        }
    }

    private PreparedParameter prepare(Parameter parameter) {
        int pid = parameter.getId();
        io.higson.runtime.model.Parameter meta = (io.higson.runtime.model.Parameter)parameter.getMetadata();
        if (meta != null && meta.isSlave()) {
            this.log.debug("[prepare] - slave detected, use std prepare");
            return this.prepareParameter(parameter);
        }
        CacheEntry<PreparedParameter> cacheEntry = this.findInCache(pid);
        if (cacheEntry != null) {
            this.log.debug("prepared parameter for pid={} already cached: {}", (Object)pid, cacheEntry);
            return cacheEntry.getValue();
        }
        return this.prepareParameter(parameter);
    }

    private PreparedParameter prepareParameter(Parameter parameter) {
        int levelCount = this.getLevelCount(parameter);
        PreparedLevel[] levels = new PreparedLevel[levelCount];
        Type[] types = new Type[levelCount];
        Matcher[] matchers = new Matcher[levelCount];
        MatchMode[] modes = new MatchMode[levelCount];
        for (int i = 0; i < levelCount; ++i) {
            PreparedLevel preparedLevel;
            Level level = this.getLevel(parameter, i);
            levels[i] = preparedLevel = this.levelPreparer.prepare(level);
            types[i] = preparedLevel.getType();
            matchers[i] = preparedLevel.getMatcher();
            modes[i] = preparedLevel.getMode();
        }
        PreparedParameter pp = new PreparedParameter(parameter, levels, this.idleChecker);
        pp.setLevelNameMap(this.buildLevelNameToIndexMap(pp));
        if (parameter.isCacheable()) {
            pp.setIndex(this.buildIndex(parameter, types, matchers, modes));
        }
        pp.setMetadata(parameter.getMetadata());
        return pp;
    }

    private CacheEntry<PreparedParameter> findInCache(int pid) {
        List<CacheEntry<PreparedParameter>> snapshot = this.cache.list();
        for (CacheEntry<PreparedParameter> e : snapshot) {
            if (e.getValue().getId() != pid) continue;
            return e;
        }
        return null;
    }

    private LevelIndex<String[]> buildIndex(Parameter parameter, Type<?>[] types, Matcher[] matchers, MatchMode[] modes) {
        int inputLevelCount = parameter.getInputLevels();
        Type<?>[] inputLevelTypes = Arrays.copyOf(types, inputLevelCount);
        Matcher[] inputLevelMatchers = Arrays.copyOf(matchers, inputLevelCount);
        MatchMode[] inputLevelModes = Arrays.copyOf(modes, inputLevelCount);
        LevelIndex<String[]> index = new LevelIndex<String[]>(inputLevelCount, inputLevelTypes, inputLevelMatchers);
        index.setMatchModes(inputLevelModes);
        boolean throwOnNormalize = this.properties != null && this.properties.isThrowOnNormalizeInputValueException();
        for (ParameterEntry parameterEntry : parameter.getEntries()) {
            String[] keys = parameterEntry.getLevels();
            for (int i = 0; i < inputLevelCount; ++i) {
                if (matchers[i] != null) continue;
                keys[i] = InputValueNormalizer.normalize(types[i], keys[i], throwOnNormalize);
            }
            index.add(keys, this.prepareOutput(parameterEntry, inputLevelCount));
        }
        index.trim();
        return index;
    }

    private Map<String, Integer> buildLevelNameToIndexMap(PreparedParameter preparedParameter) {
        LinkedHashMap<String, Integer> nameMap = new LinkedHashMap<String, Integer>();
        int inputLevelCount = preparedParameter.getInputLevelsCount();
        int levelCount = preparedParameter.getLevelCount();
        PreparedLevel[] levels = preparedParameter.getLevels();
        for (int currentLevelIndex = inputLevelCount; currentLevelIndex < levelCount; ++currentLevelIndex) {
            PreparedLevel level = levels[currentLevelIndex];
            if (level.getName() == null) continue;
            nameMap.put(level.getName(), currentLevelIndex - inputLevelCount);
        }
        return nameMap;
    }

    private int getLevelCount(Parameter parameter) {
        List<Level> levels = parameter.getLevels();
        return levels != null ? levels.size() : 0;
    }

    private Level getLevel(Parameter parameter, int index) {
        return parameter.getLevels().get(index);
    }

    private PreparedEntry prepareEntry(ParameterEntry parameterEntry) {
        return new PreparedEntry(parameterEntry);
    }

    private String[] prepareOutput(ParameterEntry parameterEntry, int inputLevelCount) {
        return new PreparedOutput(parameterEntry, inputLevelCount).getLevels();
    }

    @Override
    public List<PreparedEntry> findEntries(int pid, String[][] levelValues) {
        Collection<ParameterEntry> entries = this.parameterProvider.findEntries(pid, levelValues);
        ArrayList<PreparedEntry> result = new ArrayList<PreparedEntry>(entries.size());
        for (ParameterEntry pe : entries) {
            result.add(this.prepareEntry(pe));
        }
        return result;
    }

    @Override
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setIdleChecker(IdleChecker idleChecker) {
        this.idleChecker = Objects.requireNonNull(idleChecker);
    }

    public boolean isFastReturnForLoad() {
        return this.fastReturnForLoad;
    }

    public void setFastReturnForLoad(boolean fastReturnForLoad) {
        this.fastReturnForLoad = fastReturnForLoad;
    }
}

