/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.engine.core.prepared;

import io.higson.runtime.engine.core.matcher.Matcher;
import io.higson.runtime.engine.core.prepared.PreparedLevel;
import io.higson.runtime.engine.core.prepared.PreparedParameter;
import io.higson.runtime.engine.core.type.Type;
import io.higson.runtime.engine.core.type.ValueHolder;
import io.higson.runtime.engine.types.string.StringType;
import io.higson.runtime.helper.LevelConstants;
import io.higson.runtime.matcher.AbstractSetMatcher;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InputValueNormalizer {
    private static final Logger log = LoggerFactory.getLogger(InputValueNormalizer.class);

    private InputValueNormalizer() {
        throw new UnsupportedOperationException();
    }

    public static String[][] normalize(PreparedParameter param, Object[][] allLevelValues, boolean throwOnNormalizeInputValueException) {
        int size = allLevelValues != null ? Math.min(allLevelValues.length, param.getInputLevelsCount()) : 0;
        String[][] normalized = new String[size][];
        for (int i = 0; i < size; ++i) {
            PreparedLevel level = param.getLevels()[i];
            Object[] levelValues = allLevelValues[i];
            Type<? extends ValueHolder> type = level.getType();
            normalized[i] = InputValueNormalizer.normalizeLevel(type, level, levelValues, throwOnNormalizeInputValueException);
        }
        return normalized;
    }

    private static <T extends ValueHolder> String[] normalizeLevel(Type<T> type, PreparedLevel level, Object[] levelObject, boolean throwOnNormalizeInputValueException) {
        if (levelObject == null) {
            return new String[0];
        }
        String[] normalizedValues = new String[levelObject.length];
        for (int i = 0; i < levelObject.length; ++i) {
            Object currValue = levelObject[i];
            if (currValue instanceof String) {
                normalizedValues[i] = InputValueNormalizer.normalizeValue(type, (String)currValue, level.getMatcher(), throwOnNormalizeInputValueException);
                continue;
            }
            T decoded = type.convert(currValue);
            normalizedValues[i] = type.encode(decoded);
        }
        return normalizedValues;
    }

    private static <T extends ValueHolder> String normalizeValue(Type<T> type, String levelValue, Matcher matcher, boolean throwOnNormalizeInputValueException) {
        if (LevelConstants.ASTERISK.getValue().equals(levelValue)) {
            return levelValue;
        }
        if (type.getClass() == StringType.class) {
            return levelValue;
        }
        String separator = InputValueNormalizer.getMatcherSeparator(matcher);
        if (separator == null) {
            return InputValueNormalizer.normalize(type, levelValue, throwOnNormalizeInputValueException);
        }
        return InputValueNormalizer.normalizeWithMatcherSeparator(type, separator, levelValue, throwOnNormalizeInputValueException);
    }

    private static String getMatcherSeparator(Matcher matcher) {
        if (matcher instanceof AbstractSetMatcher) {
            return Character.toString(((AbstractSetMatcher)matcher).getSeparator());
        }
        return null;
    }

    public static <T extends ValueHolder> String normalize(Type<T> type, String levelValue, boolean throwOnNormalizeInputValueException) {
        if (LevelConstants.ASTERISK.getValue().equals(levelValue)) {
            return levelValue;
        }
        if (type.getClass() == StringType.class) {
            return levelValue;
        }
        try {
            T decoded = type.decode(levelValue);
            return type.encode(decoded);
        }
        catch (RuntimeException e) {
            InputValueNormalizer.logError(levelValue, type);
            if (throwOnNormalizeInputValueException) {
                throw e;
            }
            return levelValue;
        }
    }

    private static void logError(String levelValue, Type t) {
        String prettyTypeName = t.getClass().getSimpleName();
        log.error(String.format("failed to normalize cell value: '%s' of type: %s", levelValue, prettyTypeName));
    }

    private static <T extends ValueHolder> String normalizeWithMatcherSeparator(Type<T> type, String separator, String levelValue, boolean throwOnNormalizeInputValueException) {
        return Arrays.stream(levelValue.split(separator)).map(lv -> InputValueNormalizer.normalize(type, lv, throwOnNormalizeInputValueException)).collect(Collectors.joining(separator));
    }
}

