/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.engine.types.datetime;

import io.higson.runtime.engine.types.date.AbstractDateParserChain;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

class LocalDateTimeParserChain
extends AbstractDateParserChain<LocalDateTime> {
    private LocalDateTimeParserChain(DateTimeFormatter formatter) {
        super(formatter);
    }

    @Override
    protected LocalDateTime doParse(String text, DateTimeFormatter formatter) {
        return LocalDateTime.parse(text, formatter);
    }

    static LocalDateTimeParserChain build() {
        LocalDateTimeParserChain isoLocalDateTime = new LocalDateTimeParserChain(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        LocalDateTimeParserChain isoOffsetDateTime = new LocalDateTimeParserChain(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        isoLocalDateTime.setNext(isoOffsetDateTime);
        LocalDateTimeParserChain isoZonedDateTime = new LocalDateTimeParserChain(DateTimeFormatter.ISO_ZONED_DATE_TIME);
        isoOffsetDateTime.setNext(isoZonedDateTime);
        LocalDateTimeParserChain isoDateTime = new LocalDateTimeParserChain(DateTimeFormatter.ISO_DATE_TIME);
        isoZonedDateTime.setNext(isoDateTime);
        LocalDateTimeParserChain rfc1123DateTime = new LocalDateTimeParserChain(DateTimeFormatter.RFC_1123_DATE_TIME);
        isoDateTime.setNext(rfc1123DateTime);
        return isoLocalDateTime;
    }
}

