/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.flow;

import io.higson.runtime.flow.Action;
import io.higson.runtime.flow.Link;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.List;

public class Node {
    private String id;
    private List<Action> actions;
    private List<Link> links;
    @Nullable
    private String defaultNextNode;

    public List<Link> getLinks() {
        return this.links != null ? this.links : Collections.emptyList();
    }

    public String toString() {
        return "Node[" + this.id + "]";
    }

    Node(String id, List<Action> actions, List<Link> links, @Nullable String defaultNextNode) {
        this.id = id;
        this.actions = actions;
        this.links = links;
        this.defaultNextNode = defaultNextNode;
    }

    public static NodeBuilder builder() {
        return new NodeBuilder();
    }

    public String getId() {
        return this.id;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    @Nullable
    public String getDefaultNextNode() {
        return this.defaultNextNode;
    }

    public static class NodeBuilder {
        private String id;
        private List<Action> actions;
        private List<Link> links;
        private String defaultNextNode;

        NodeBuilder() {
        }

        public NodeBuilder id(String id) {
            this.id = id;
            return this;
        }

        public NodeBuilder actions(List<Action> actions) {
            this.actions = actions;
            return this;
        }

        public NodeBuilder links(List<Link> links) {
            this.links = links;
            return this;
        }

        public NodeBuilder defaultNextNode(@Nullable String defaultNextNode) {
            this.defaultNextNode = defaultNextNode;
            return this;
        }

        public Node build() {
            return new Node(this.id, this.actions, this.links, this.defaultNextNode);
        }

        public String toString() {
            return "Node.NodeBuilder(id=" + this.id + ", actions=" + this.actions + ", links=" + this.links + ", defaultNextNode=" + this.defaultNextNode + ")";
        }
    }
}

