/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.helper.snapshot;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.Objects;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class XMLValidator {
    private static final Logger log = LoggerFactory.getLogger(XMLValidator.class);
    private static final String FACTORY_CLASS_NAME = "com.sun.org.apache.xerces.internal.jaxp.validation.XMLSchemaFactory";

    private XMLValidator() {
        throw new UnsupportedOperationException();
    }

    public static void validate(InputStream stream, String xsdFile) throws SAXException, IOException {
        StreamSource xml = new StreamSource(stream);
        XMLValidator.validate(xsdFile, xml);
    }

    public static void validate(String xmlSource, String xsdFile) throws SAXException, IOException {
        StreamSource xml = new StreamSource(new StringReader(xmlSource));
        XMLValidator.validate(xsdFile, xml);
    }

    private static void validate(String xsdFile, Source xml) throws SAXException, IOException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        SchemaFactory schemaFactory = XMLValidator.createSchemaFactory();
        URL xsdResource = loader.getResource(xsdFile);
        if (Objects.isNull(xsdResource)) {
            log.warn("cannot get resource from file:{}, validation aborted", (Object)xsdFile);
        } else {
            Schema schema = schemaFactory.newSchema(xsdResource);
            Validator validator = XMLValidator.getValidator(schema);
            validator.validate(xml);
        }
    }

    private static Validator getValidator(Schema schema) throws SAXNotRecognizedException, SAXNotSupportedException {
        Validator validator = schema.newValidator();
        validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        return validator;
    }

    private static SchemaFactory createSchemaFactory() {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema", FACTORY_CLASS_NAME, null);
        try {
            schemaFactory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            schemaFactory.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return schemaFactory;
    }
}

