/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.helper.uid;

import io.higson.runtime.helper.uid.Uid;

public final class UidParser {
    private final String uid;
    private String code;
    private String ver;
    private int sid;
    private int mid;
    private State state = State.CODE;
    private int pos;

    private UidParser(String uid) {
        this.uid = uid;
    }

    private Uid parse() {
        block5: for (int ix = 0; ix < this.uid.length(); ++ix) {
            char c = this.uid.charAt(ix);
            switch (c) {
                case '@': {
                    this.readTo(ix);
                    this.state = State.VER;
                    continue block5;
                }
                case ':': {
                    this.readTo(ix);
                    this.state = State.SID;
                    continue block5;
                }
                case '%': {
                    this.readTo(ix);
                    this.state = State.MID;
                    continue block5;
                }
            }
        }
        this.readTo(this.uid.length());
        return new Uid(this.code, this.ver, this.sid, this.mid);
    }

    private void readTo(int ix) {
        switch (this.state) {
            case CODE: {
                this.code = this.uid.substring(this.pos, ix);
                break;
            }
            case VER: {
                this.ver = this.uid.substring(this.pos, ix);
                break;
            }
            case SID: {
                this.sid = Integer.parseInt(this.uid.substring(this.pos, ix));
                break;
            }
            case MID: {
                this.mid = Integer.parseInt(this.uid.substring(this.pos, ix));
                break;
            }
        }
        this.pos = ix + 1;
    }

    public static Uid parseUid(String uid) {
        return new UidParser(uid).parse();
    }

    private static enum State {
        CODE,
        VER,
        SID,
        MID;

    }
}

