/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.invoker;

import io.higson.runtime.core.HigsonEngine;
import io.higson.runtime.engine.core.function.Function;
import io.higson.runtime.engine.core.function.FunctionInvoker;
import io.higson.runtime.exception.HigsonRuntimeException;
import io.higson.runtime.flow.Flow;
import io.higson.runtime.flow.FlowExecutor;
import io.higson.runtime.flow.FlowResult;
import io.higson.runtime.flow.dto.FlowRuntimeConverter;
import io.higson.runtime.invoker.GroovyFunctionInvoker;
import io.higson.runtime.model.FlowFunction;
import io.higson.runtime.profiler.engine.EngineProfiler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowInvoker
implements FunctionInvoker {
    private static final Logger log = LoggerFactory.getLogger(FlowInvoker.class);
    private static final EngineProfiler profiler = EngineProfiler.FUNCTION;
    private HigsonEngine higsonEngine;
    private final GroovyFunctionInvoker groovyFunctionInvoker;

    public FlowInvoker(GroovyFunctionInvoker groovyFunctionInvoker) {
        this.groovyFunctionInvoker = groovyFunctionInvoker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Function function, Object ... args) {
        long t = System.currentTimeMillis();
        try {
            FlowFunction flowFunction = this.cast(function);
            FlowResult flowResult = this.getFlowExecutor(flowFunction, args).execute();
            return flowResult;
        }
        finally {
            profiler.addGetMeasure(function.getName(), t, System.currentTimeMillis());
        }
    }

    private FlowExecutor getFlowExecutor(FlowFunction flowFunction, Object[] args) {
        Flow flow = FlowRuntimeConverter.convert(flowFunction.getBody());
        return new FlowExecutor(this.higsonEngine, this.groovyFunctionInvoker, flow, flowFunction.getName(), args);
    }

    private FlowFunction cast(Function function) {
        if (function instanceof FlowFunction) {
            return (FlowFunction)function;
        }
        log.error("Unexpected function: {}", (Object)function);
        throw new HigsonRuntimeException("Illegal function passed to FlowInvoker: " + function);
    }

    public void setHigsonEngine(HigsonEngine higsonEngine) {
        this.higsonEngine = higsonEngine;
    }
}

