/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.model;

import io.higson.runtime.core.HigsonContext;
import io.higson.runtime.core.domain.AttributeValueProvider;
import io.higson.runtime.engine.core.context.ParamContext;
import io.higson.runtime.engine.core.output.ParamValue;
import io.higson.runtime.engine.core.type.ValueHolder;
import io.higson.runtime.helper.TypeConverter;
import io.higson.runtime.model.DomainAttributeDto;
import io.higson.runtime.model.DomainObject;
import io.higson.runtime.model.DomainObjectType;
import io.higson.runtime.model.Type;
import io.higson.runtime.profiler.attribute.AttributeKey;
import io.higson.runtime.profiler.engine.AttributeEngineProfiler;
import java.math.BigDecimal;
import java.util.Date;

public class DomainAttribute {
    private static final TypeConverter type = TypeConverter.getInstance();
    private static final AttributeEngineProfiler DOMAIN_PROFILER = AttributeEngineProfiler.DOMAIN;
    private final DomainAttributeDto attribute;
    private final DomainObject object;
    private final AttributeValueProvider valueProvider;

    public int getId() {
        return this.attribute.getId();
    }

    public String getCode() {
        return this.attribute.getCode();
    }

    public String getName() {
        return this.attribute.getName();
    }

    public String getDescription() {
        return this.attribute.getDescription();
    }

    public String getRawValue() {
        return this.attribute.getRawValue();
    }

    public Type getRawType() {
        return this.attribute.getRawType();
    }

    public DomainObjectType getDomainType() {
        return this.attribute.getDomainType();
    }

    public DomainObject getDomainObject() {
        return this.object;
    }

    public int getDomainObjectId() {
        return this.attribute.getDomainObjectId();
    }

    public String getType() {
        return this.attribute.getType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParamValue getValue(ParamContext ctx, Object ... args) {
        long start = System.currentTimeMillis();
        try {
            ParamValue paramValue = this.valueProvider.getValue(this, ctx, args);
            return paramValue;
        }
        finally {
            DOMAIN_PROFILER.addInvokeMeasure(new AttributeKey(this.object.getPath(), this.attribute.getCode()), start, System.currentTimeMillis());
        }
    }

    public String getString(HigsonContext ctx) {
        return type.getString(this.holder(ctx));
    }

    public BigDecimal getDecimal(HigsonContext ctx) {
        return type.getDecimal(this.holder(ctx));
    }

    public double getNumber(HigsonContext ctx) {
        return type.getNumber(this.holder(ctx));
    }

    public Integer getInteger(HigsonContext ctx) {
        return type.getInteger(this.holder(ctx));
    }

    public Long getLong(HigsonContext ctx) {
        return type.getLong(this.holder(ctx));
    }

    public Date getDate(HigsonContext ctx) {
        return type.getDate(this.holder(ctx));
    }

    public Boolean getBoolean(HigsonContext ctx) {
        return type.toBooleanHolder(this.holder(ctx)).getBoolean();
    }

    public ValueHolder getHolder(HigsonContext ctx) {
        return this.holder(ctx);
    }

    public double doubleValue(HigsonContext ctx) {
        return type.getNumber(this.holder(ctx));
    }

    public int intValue(HigsonContext ctx) {
        return type.toIntegerHolder(this.holder(ctx)).intValue();
    }

    public long longValue(HigsonContext ctx) {
        return type.toIntegerHolder(this.holder(ctx)).longValue();
    }

    public boolean booleanValue(HigsonContext ctx) {
        return type.toBooleanHolder(this.holder(ctx)).booleanValue();
    }

    private ValueHolder holder(HigsonContext ctx) {
        return this.getValue(ctx, new Object[0]).getHolder();
    }

    public String getDigest() {
        return this.valueProvider.getDigest(this.attribute.getRawType(), this.attribute.getRawValue());
    }

    public String toString() {
        return "HypDomainAttr[" + this.attribute.getCode() + ": " + this.attribute.getRawValue() + "]";
    }

    public DomainAttribute(DomainAttributeDto attribute, DomainObject object, AttributeValueProvider valueProvider) {
        this.attribute = attribute;
        this.object = object;
        this.valueProvider = valueProvider;
    }

    public DomainAttributeDto getAttribute() {
        return this.attribute;
    }

    public AttributeValueProvider getValueProvider() {
        return this.valueProvider;
    }
}

