/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.model;

import io.higson.runtime.engine.util.Printer;
import io.higson.runtime.model.ScheduleEntry;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;

public class Schedule {
    private final String profileCode;
    private final String region;
    private final List<ScheduleEntry> entries = new ArrayList<ScheduleEntry>();

    public Schedule(String profileCode, String region) {
        this.profileCode = profileCode;
        this.region = region;
    }

    public void addEntry(ScheduleEntry e) {
        this.entries.add(e);
        int i = this.entries.size() - 1;
        if (i >= 1) {
            this.entries.get(i - 1).setDateTo(this.entries.get(i).getDateFrom());
        }
    }

    public Optional<ScheduleEntry> find(Date date) {
        return this.entries.stream().filter(entry -> this.lowerCondition(date, entry.getDateFrom()) && this.upperCondition(date, entry.getDateTo())).findFirst();
    }

    private boolean lowerCondition(Date d, Date lowerBound) {
        return lowerBound == null || lowerBound.getTime() <= d.getTime();
    }

    private boolean upperCondition(Date d, Date upperBound) {
        return upperBound == null || d.getTime() < upperBound.getTime();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MpSchedule[");
        sb.append("profileCode=").append(this.profileCode);
        sb.append(",region=").append(this.region);
        if (!this.entries.isEmpty()) {
            sb.append(Printer.print(this.entries, "schedule entries"));
        }
        sb.append(']');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Schedule)) {
            return false;
        }
        Schedule other = (Schedule)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$profileCode = this.getProfileCode();
        String other$profileCode = other.getProfileCode();
        if (this$profileCode == null ? other$profileCode != null : !this$profileCode.equals(other$profileCode)) {
            return false;
        }
        String this$region = this.getRegion();
        String other$region = other.getRegion();
        if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
            return false;
        }
        List<ScheduleEntry> this$entries = this.entries;
        List<ScheduleEntry> other$entries = other.entries;
        return !(this$entries == null ? other$entries != null : !((Object)this$entries).equals(other$entries));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Schedule;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $profileCode = this.getProfileCode();
        result = result * 59 + ($profileCode == null ? 43 : $profileCode.hashCode());
        String $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : $region.hashCode());
        List<ScheduleEntry> $entries = this.entries;
        result = result * 59 + ($entries == null ? 43 : ((Object)$entries).hashCode());
        return result;
    }

    public String getProfileCode() {
        return this.profileCode;
    }

    public String getRegion() {
        return this.region;
    }
}

