/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.mp.simulation.samples.iterator;

import io.higson.runtime.mp.simulation.samples.RangeBasedSamples;
import io.higson.runtime.mp.simulation.samples.iterator.BaseRangeIterator;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;

public class DateRangeIterator
extends BaseRangeIterator<Date> {
    private static final String MINUTE_CHAR = "m";
    private static final String HOUR_CHAR = "g";
    private static final String MONTH_CHAR = "mc";
    private static final String YEAR_CHAR = "r";
    private String stepType;

    public DateRangeIterator(RangeBasedSamples<Date> sampler, String stepType) {
        super(sampler);
        this.stepType = stepType;
    }

    @Override
    protected Date computeNext(Date current, BigDecimal step) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(current == null ? (Date)this.samples.getMin() : current);
        switch (this.stepType) {
            case "m": {
                cal.add(12, step.intValue());
                break;
            }
            case "g": {
                cal.add(11, step.intValue());
                break;
            }
            case "mc": {
                cal.add(2, step.intValue());
                break;
            }
            case "r": {
                cal.add(1, step.intValue());
                break;
            }
            default: {
                cal.add(5, step.intValue());
            }
        }
        return cal.getTime();
    }

    @Override
    protected int compare(Date val1, Date val2) {
        return val1.compareTo(val2);
    }
}

