/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.profiler.jdbc;

import io.higson.runtime.engine.util.Separator;
import io.higson.runtime.exception.HigsonRuntimeException;
import io.higson.runtime.helper.SqlUtil;
import io.higson.runtime.profiler.jdbc.QueryStat;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcProfiler {
    private static final Logger log = LoggerFactory.getLogger((String)"jdbc_profiler");
    private static final Logger defLog = LoggerFactory.getLogger(JdbcProfiler.class);
    private static final int SUMMARY_INIT_SIZE = 2000;
    private static final int SQL_PART_LEN = 110;
    private static final int INITIAL_CAPACITY = 256;
    private static final String NL = Separator.DEFAULT.getValue();
    private static JdbcProfiler singleton = new JdbcProfiler();
    private boolean logEachSql;
    private final Map<String, Integer> sql2uid = new HashMap<String, Integer>(256);
    private final Map<Integer, QueryStat> queryStatMap = new HashMap<Integer, QueryStat>(256);
    private int eventCount;
    private int nextSqlUid;

    public static JdbcProfiler getSingleton() {
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sqlExecuted(String sql, long time) {
        if (this.logEachSql && log.isInfoEnabled()) {
            log.info(String.format("[%5dms] %s", time, sql));
        }
        Integer sqlUid = this.getSqlUid(sql);
        Map<Integer, QueryStat> map = this.queryStatMap;
        synchronized (map) {
            QueryStat qa = this.queryStatMap.computeIfAbsent(sqlUid, uid -> new QueryStat(sql, (int)uid));
            qa.addMeasure(time);
            ++this.eventCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer getSqlUid(String sql) {
        Map<String, Integer> map = this.sql2uid;
        synchronized (map) {
            Integer uid = this.sql2uid.get(sql);
            if (uid == null) {
                uid = this.nextSqlUid++;
                this.sql2uid.put(sql, uid);
                if (log.isInfoEnabled()) {
                    log.info("generated sql uid: {} for sql:\n{}\n", (Object)this.uidToStr(uid), (Object)sql);
                }
            }
            return uid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<QueryStat> getQueryStats() {
        ArrayList<QueryStat> sqlList;
        Map<Integer, QueryStat> map = this.queryStatMap;
        synchronized (map) {
            sqlList = new ArrayList<QueryStat>(this.queryStatMap.values());
        }
        Collections.sort(sqlList);
        return sqlList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getEventsCount() {
        Map<Integer, QueryStat> map = this.queryStatMap;
        synchronized (map) {
            return this.eventCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<Integer, QueryStat> map = this.queryStatMap;
        synchronized (map) {
            this.queryStatMap.clear();
            this.eventCount = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryStat findQueryWithFragment(String fragment) {
        Map<Integer, QueryStat> map = this.queryStatMap;
        synchronized (map) {
            for (QueryStat stat : this.queryStatMap.values()) {
                if (!stat.getSql().contains(fragment)) continue;
                return stat;
            }
        }
        return null;
    }

    public void printSummaryDef() {
        this.printSummary(defLog);
    }

    public void printSummary() {
        this.printSummary(log);
    }

    public void printSummary(Logger log) {
        StringBuilder sb = this.printSummaryToBuffer(110);
        log.info("profiler summary: {}", (Object)(NL + NL + sb));
        log.info("profiler summary end");
    }

    public StringBuilder printSummaryToBuffer(int sqlPartLen) {
        StringBuilder sb = new StringBuilder(2000);
        this.addLine(sb, " UID | totalTime |  count |  avgTime | sql fragment" + this.lpad("|", sqlPartLen - 10));
        List<QueryStat> sqlList = this.getQueryStats();
        for (QueryStat qs : sqlList) {
            String sql = qs.getSql().trim();
            this.append(sb, this.lpad(this.uidToStr(qs.getSqlUid()), 4)).append(" |");
            this.append(sb, this.lpad(qs.getTotalTime(), 10)).append(" |");
            this.append(sb, this.lpad(qs.getCount(), 7)).append(" |");
            this.append(sb, this.lpad(String.format("%2.2f", qs.getAvg()), 9)).append(" | ");
            this.append(sb, this.rpad(SqlUtil.getPart(sql, sqlPartLen), sqlPartLen)).append(" |");
            this.newline(sb);
        }
        return sb;
    }

    public String printSummaryAsHtml() {
        StringWriter writer = new StringWriter(2000);
        this.writeSummaryAsHtml(writer);
        return writer.toString();
    }

    public void writeSummaryAsHtml(Writer w) {
        this.write(w, "<html>");
        this.write(w, "<pre>");
        this.write(w, this.printSummaryToBuffer(130).toString());
        this.write(w, "</pre>");
        this.write(w, "<br /> <br />");
        for (QueryStat qs : this.getQueryStats()) {
            this.write(w, "<br />");
            this.write(w, "UID: <b>" + this.uidToStr(qs.getSqlUid()) + "</b>");
            this.write(w, "<br/>");
            this.write(w, "<pre>");
            this.write(w, qs.getSql());
            this.write(w, "</pre>");
            this.write(w, "<br />");
        }
        this.write(w, "</html>");
    }

    private void write(Writer writer, String str) {
        try {
            writer.write(str);
        }
        catch (IOException e) {
            throw new HigsonRuntimeException("writing to stream failed", e);
        }
    }

    private void addLine(StringBuilder sb, String line) {
        sb.append(line).append(NL);
    }

    private StringBuilder append(StringBuilder sb, String text) {
        return sb.append(text);
    }

    private void newline(StringBuilder sb) {
        sb.append(NL);
    }

    public static void logEachStatement(boolean each) {
        JdbcProfiler.getSingleton().setLogEachSql(each);
    }

    private String lpad(String text, int size) {
        return StringUtils.leftPad((String)text, (int)size);
    }

    private String lpad(Object obj, int size) {
        return this.lpad(String.valueOf(obj), size);
    }

    private String rpad(String text, int size) {
        return StringUtils.rightPad((String)text, (int)size);
    }

    private String uidToStr(int uid) {
        return StringUtils.leftPad((String)String.valueOf(uid), (int)4, (char)'0');
    }

    public void setLogEachSql(boolean logEachSql) {
        this.logEachSql = logEachSql;
    }
}

