/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.provider.external;

import io.higson.runtime.dao.util.RowCallbackHandler;
import io.higson.runtime.engine.matchers.BetweenMatcherTokenSeparator;
import io.higson.runtime.engine.matchers.RangeToken;
import io.higson.runtime.helper.ConstantsUtil;
import io.higson.runtime.helper.LevelConstants;
import io.higson.runtime.helper.MpHelper;
import io.higson.runtime.helper.TypeConverter;
import io.higson.runtime.model.MpParameterEntry;
import io.higson.runtime.model.Parameter;
import io.higson.runtime.model.ParameterLevel;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;

class ExtRowCallbackHandler
implements RowCallbackHandler {
    private final Parameter parameter;
    private final TypeConverter typeConverter;
    private final MpHelper helper;
    private final BetweenMatcherTokenSeparator separator;

    ExtRowCallbackHandler(Parameter parameter) {
        this.parameter = parameter;
        this.typeConverter = TypeConverter.getInstance();
        this.helper = new MpHelper();
        this.separator = new BetweenMatcherTokenSeparator();
    }

    @Override
    public void processRow(ResultSet rs) throws SQLException {
        int levelCnt = this.parameter.getLevelCount();
        String[] row = new String[levelCnt];
        for (int i = 0; i < levelCnt; ++i) {
            Object obj = rs.getObject(i + 1);
            if (obj == null) continue;
            ParameterLevel parameterLevel = this.parameter.getLevel(i);
            String type = parameterLevel.getType();
            row[i] = LevelConstants.ASTERISK.getValue().equals(obj.toString()) ? LevelConstants.ASTERISK.getValue() : (this.isBetweenMatcher(parameterLevel.getMatcher()) ? this.getBetweenMatcherConvertedValue(obj, type) : this.typeConverter.toHolder(obj, type).getString());
        }
        MpParameterEntry entry = this.helper.createEntry(this.parameter, row);
        this.parameter.addEntry(entry);
    }

    private boolean isBetweenMatcher(String matcher) {
        return StringUtils.isNotEmpty((CharSequence)matcher) && ConstantsUtil.BETWEEN_MATCHERS.contains(matcher);
    }

    private String getBetweenMatcherConvertedValue(Object value, String type) {
        String parsedRangeValues = this.typeConverter.getString(value);
        RangeToken rangeToken = this.separator.separate(parsedRangeValues, this.typeConverter.getType(type));
        String convertedLowerRange = this.typeConverter.toHolder((Object)rangeToken.getLower(), type).getString();
        String convertedUpperRange = this.typeConverter.toHolder((Object)rangeToken.getUpper(), type).getString();
        return convertedLowerRange + rangeToken.getSeparator() + convertedUpperRange;
    }
}

