/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.sync;

import io.higson.runtime.cache.UserRegionVersionCache;
import io.higson.runtime.core.datasource.VersionDao;
import io.higson.runtime.engine.core.function.FunctionCache;
import io.higson.runtime.engine.core.prepared.PreparedParamCache;
import io.higson.runtime.model.RegionVersion;
import io.higson.runtime.sync.BaseWatcher;
import io.higson.runtime.sync.SyncResult;
import io.higson.runtime.version.system.SystemVersionCache;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class VersionRuntimeWatcher
extends BaseWatcher
implements Runnable {
    private final VersionDao dao;
    private final FunctionCache functionCache;
    private final PreparedParamCache paramCache;
    private final SystemVersionCache systemVersionCache;
    private final UserRegionVersionCache userRegionVersionCache;
    private Map<Integer, RegionVersion> versionMap = new HashMap<Integer, RegionVersion>();
    protected Date timestamp;

    public VersionRuntimeWatcher(VersionDao dao, FunctionCache functionCache, PreparedParamCache paramCache, SystemVersionCache systemVersionCache, UserRegionVersionCache userRegionVersionCache) {
        this.dao = dao;
        this.functionCache = functionCache;
        this.paramCache = paramCache;
        this.systemVersionCache = systemVersionCache;
        this.userRegionVersionCache = userRegionVersionCache;
    }

    @Override
    public void doWatch() {
        this.log.debug("starting version runtime watcher");
        Date lastUpdate = this.dao.getMaxLastUpdate();
        if (this.log.isDebugEnabled()) {
            this.log.debug("max last update:{}", (Object)this.print(lastUpdate));
        }
        if (this.possibleModification(lastUpdate)) {
            this.checkModification(lastUpdate);
        }
        this.log.debug("version runtime watcher finished");
    }

    private void checkModification(Date lastUpdate) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("newer last update: {}", (Object)this.print(lastUpdate));
        }
        Map<Integer, RegionVersion> freshMap = this.dao.getAllRegionVersions();
        this.log.debug("fetched {} fresh versions", (Object)freshMap.size());
        SyncResult<RegionVersion> result = this.sync(this.versionMap, freshMap);
        if (result.hasAnyChanges()) {
            this.log.debug("detected version modifications: {}", result);
            this.invalidateTrackedElements(result);
        }
        this.versionMap = freshMap;
        this.timestamp = lastUpdate;
        if (this.log.isDebugEnabled()) {
            this.log.debug("last update set to: {}", (Object)this.print(this.timestamp));
        }
    }

    private InvalidElementsDetails getRegionsNeededToInvalidate(SyncResult<RegionVersion> sync) {
        HashSet<Integer> regionIds = new HashSet<Integer>();
        HashSet<String> profileCodes = new HashSet<String>();
        for (RegionVersion ver : sync.getUpdated()) {
            regionIds.add(ver.getRegionId());
            profileCodes.add(ver.getProfileCode());
        }
        for (RegionVersion ver : sync.getCreated()) {
            regionIds.add(ver.getRegionId());
            profileCodes.add(ver.getProfileCode());
        }
        for (RegionVersion ver : sync.getDeleted()) {
            regionIds.add(ver.getRegionId());
            profileCodes.add(ver.getProfileCode());
        }
        return new InvalidElementsDetails(regionIds, profileCodes);
    }

    private void invalidateTrackedElements(SyncResult<RegionVersion> sync) {
        InvalidElementsDetails invalidElementsDetails = this.getRegionsNeededToInvalidate(sync);
        for (Integer regionId : invalidElementsDetails.getRegionIds()) {
            this.log.debug("invalidating function for region: {}", (Object)regionId);
            for (String code : this.dao.getFunctionsWithRegion(regionId)) {
                this.invalidateFunction(code);
            }
            this.log.debug("invalidating parameters for region: {}", (Object)regionId);
            for (String code : this.dao.getParametersWithRegion(regionId)) {
                this.invalidateParameter(code);
            }
        }
        for (String profileCode : invalidElementsDetails.getProfileCodes()) {
            this.systemVersionCache.invalidate(profileCode);
            this.userRegionVersionCache.invalidateForProfile(profileCode);
        }
    }

    public SyncResult<RegionVersion> sync(Map<Integer, RegionVersion> prevMap, Map<Integer, RegionVersion> freshMap) {
        int vid;
        this.log.debug("syncing versions");
        SyncResult<RegionVersion> result = new SyncResult<RegionVersion>();
        Collection<RegionVersion> currList = freshMap.values();
        Collection<RegionVersion> prevList = prevMap.values();
        for (RegionVersion curr : currList) {
            vid = curr.getId();
            RegionVersion prev = prevMap.get(vid);
            if (prev != null && !this.eq(prev, curr)) {
                this.log.trace("adding modified version:{}", (Object)curr);
                result.addUpdated(curr);
            }
            if (prev != null) continue;
            this.log.trace("adding new version:{}", (Object)curr);
            result.addCreated(curr);
        }
        for (RegionVersion prev : prevList) {
            vid = prev.getId();
            if (freshMap.containsKey(vid)) continue;
            this.log.trace("removing version:{}", (Object)prev);
            result.addDeleted(prev);
        }
        return result;
    }

    private boolean eq(RegionVersion v1, RegionVersion v2) {
        Date d1 = v1.getLastUpdate();
        Date d2 = v2.getLastUpdate();
        return Objects.equals(d1, d2);
    }

    private void invalidateFunction(String code) {
        this.functionCache.invalidate(code);
    }

    private void invalidateParameter(String code) {
        this.paramCache.invalidate(code);
    }

    private boolean possibleModification(Date lastUpdate) {
        return lastUpdate != null && (this.timestamp == null || lastUpdate.getTime() > this.timestamp.getTime());
    }

    @Override
    protected void initWatcher() {
        this.versionMap = this.dao.getAllRegionVersions();
    }

    @Override
    protected String getWatcherName() {
        return "version-watcher";
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    private final class InvalidElementsDetails {
        private final Set<Integer> regionIds;
        private final Set<String> profileCodes;

        public InvalidElementsDetails(Set<Integer> regionIds, Set<String> profileCodes) {
            this.regionIds = regionIds;
            this.profileCodes = profileCodes;
        }

        public Set<Integer> getRegionIds() {
            return this.regionIds;
        }

        public Set<String> getProfileCodes() {
            return this.profileCodes;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InvalidElementsDetails)) {
                return false;
            }
            InvalidElementsDetails other = (InvalidElementsDetails)o;
            Set<Integer> this$regionIds = this.getRegionIds();
            Set<Integer> other$regionIds = other.getRegionIds();
            if (this$regionIds == null ? other$regionIds != null : !((Object)this$regionIds).equals(other$regionIds)) {
                return false;
            }
            Set<String> this$profileCodes = this.getProfileCodes();
            Set<String> other$profileCodes = other.getProfileCodes();
            return !(this$profileCodes == null ? other$profileCodes != null : !((Object)this$profileCodes).equals(other$profileCodes));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Set<Integer> $regionIds = this.getRegionIds();
            result = result * 59 + ($regionIds == null ? 43 : ((Object)$regionIds).hashCode());
            Set<String> $profileCodes = this.getProfileCodes();
            result = result * 59 + ($profileCodes == null ? 43 : ((Object)$profileCodes).hashCode());
            return result;
        }

        public String toString() {
            return "VersionRuntimeWatcher.InvalidElementsDetails(regionIds=" + this.getRegionIds() + ", profileCodes=" + this.getProfileCodes() + ")";
        }
    }
}

