/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.version.system;

import io.higson.runtime.core.datasource.VersionDao;
import io.higson.runtime.version.system.SystemVersionCache;
import io.higson.runtime.version.system.SystemVersionProvider;
import jakarta.validation.constraints.NotNull;
import java.util.SortedSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemVersionProviderImpl
implements SystemVersionProvider {
    private static final Logger log = LoggerFactory.getLogger(SystemVersionProviderImpl.class);
    private final SystemVersionCache systemVersionCache;
    private final VersionDao dao;

    @Override
    public SortedSet<Integer> get(@NotNull String profileCode, @NotNull SortedSet<Integer> versionIdsToOmit) {
        return this.systemVersionCache.get(profileCode, versionIdsToOmit).orElseGet(() -> this.getFromDB(profileCode, versionIdsToOmit));
    }

    private SortedSet<Integer> getFromDB(String profileCode, SortedSet<Integer> versionIdsToOmit) {
        log.debug("cache hit miss, getting system versions for profile code:{} from db", (Object)profileCode);
        SortedSet<Integer> systemVersions = this.dao.getSystemVersions(profileCode, versionIdsToOmit);
        this.systemVersionCache.put(profileCode, versionIdsToOmit, systemVersions);
        return systemVersions;
    }

    public SystemVersionProviderImpl(SystemVersionCache systemVersionCache, VersionDao dao) {
        this.systemVersionCache = systemVersionCache;
        this.dao = dao;
    }
}

