/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.engine.types.integer;

import java.math.BigDecimal;
import org.smartparam.engine.core.type.AbstractValueHolder;

public class IntegerHolder
extends AbstractValueHolder {
    private final Long value;

    public IntegerHolder(Long value) {
        this.value = value;
    }

    @Override
    public Long getValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value != null ? this.value.intValue() : 0;
    }

    @Override
    public long longValue() {
        return this.value != null ? this.value : 0L;
    }

    @Override
    public BigDecimal getBigDecimal() {
        return this.value != null ? BigDecimal.valueOf(this.longValue()) : null;
    }

    @Override
    public Integer getInteger() {
        return this.value != null ? Integer.valueOf(this.value.intValue()) : null;
    }

    @Override
    public Long getLong() {
        return this.value;
    }
}

