/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.engine.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartparam.engine.core.output.MultiValue;
import pl.decerto.hyperon.runtime.exception.HyperonRuntimeException;

public class MultiValueUtil {
    private static final Logger log = LoggerFactory.getLogger(MultiValueUtil.class);
    private static final Comparator<Map.Entry<String, Integer>> mapEntryCompareByValue = Comparator.comparing(Map.Entry::getValue);

    private MultiValueUtil() {
        throw new UnsupportedOperationException();
    }

    public static List<String> getKeys(MultiValue multiValue) {
        if (multiValue == null) {
            return Collections.emptyList();
        }
        try {
            Map<String, Integer> indexMap = MultiValueUtil.getIndexMap(multiValue);
            ArrayList<Map.Entry<String, Integer>> indexMapping = new ArrayList<Map.Entry<String, Integer>>(indexMap.entrySet());
            return indexMapping.stream().sorted(mapEntryCompareByValue).map(Map.Entry::getKey).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new HyperonRuntimeException(e.getMessage(), e);
        }
    }

    private static Map<String, Integer> getIndexMap(MultiValue multiValue) throws IllegalAccessException {
        Map indexMap = (Map)FieldUtils.readField((Object)multiValue, (String)"indexMap", (boolean)true);
        if (Objects.isNull(indexMap)) {
            return Collections.emptyMap();
        }
        return indexMap;
    }
}

