INSERT INTO category (id, accesscontrol, active, description, name)
VALUES (1, true, true, 'System related', 'SYSTEM');

INSERT INTO parameter (id, archive, arrayseparator, cacheable, description, digest, head, label, lastupdate, name, nullable, sort,
                       worksessionid, regionversion_id, mastername, slave, distinct_flag, external_source, external_datasource,
                       external_inmem_query, external_nonmem_query, auto_refresh, auto_refresh_period, dictionary)
VALUES (1, false, ',', true, null, '7ab85809c33d8c23e99a5f1141e312b9a0adad6f', true, ' ', CURRENT_TIMESTAMP() ,
        'system.function.logging.level', false, null, 1, null, null, false, false, false, null, ' ', ' ', false, ' ', false);

INSERT INTO parameterentry (id, level1, level2, level3, level4, level5, level6, level7, level8, sha1code, parameter_id)
VALUES (1, '*', 'INFO', null, null, null, null, null, null, '0cb5362ff7af8f81a2face1534aba0ad554b3a35', 1);

INSERT INTO parameterlevel (leveltype, id, code, label, orderno, type, levelcreator, matcher, property, union_flag, array_flag,
                            external_flag, parameter_id_in, parameter_id_out, foreignkey, reverse_matcher)
VALUES ('input', 1, 'code', 'Function code', 0, 'string', null, 'text/regex', 'code', false, false, false, 1, null, null, false);
INSERT INTO parameterlevel (leveltype, id, code, label, orderno, type, levelcreator, matcher, property, union_flag, array_flag,
                            external_flag, parameter_id_in, parameter_id_out, foreignkey, reverse_matcher)
VALUES ('output', 2, 'loggingLevel', 'Function logging level', 1, 'string', null, 'text/regex', null, false, false, false, null, 1, null,
        false);

INSERT INTO systemrightjpa (id, code, createdate, description)
VALUES (1, 'MPP_ACCESS', CURRENT_TIMESTAMP() , 'System access');
INSERT INTO systemrightjpa (id, code, createdate, description)
VALUES (2, 'SYSTEM_CONFIG_ACCESS', CURRENT_TIMESTAMP() , 'System configuration access');
INSERT INTO systemrightjpa (id, code, createdate, description)
VALUES (3, 'SYSTEM_CONFIG_EXPORT', CURRENT_TIMESTAMP() , 'Access to bulk state export');
INSERT INTO systemrightjpa (id, code, createdate, description)
VALUES (4, 'PAR_R', CURRENT_TIMESTAMP() , 'Read-only access to parametrization elements');
INSERT INTO systemrightjpa (id, code, createdate, description)
VALUES (5, 'PAR_W', CURRENT_TIMESTAMP() , 'Modification access to parametrization elements');
INSERT INTO systemrightjpa (id, code, createdate, description)
VALUES (6, 'PAR_R_ALL', CURRENT_TIMESTAMP() , 'Read-only access to parametrization elements controlled by access control tags');
INSERT INTO systemrightjpa (id, code, createdate, description)
VALUES (7, 'PAR_W_ALL', CURRENT_TIMESTAMP() , 'Modification access to parametrization elements controlled by access control tags');
INSERT INTO systemrightjpa (id, code, createdate, description)
VALUES (8, 'MPP_OPUS_EXP', CURRENT_TIMESTAMP() , 'Access to OPUS system export');
INSERT INTO systemrightjpa (id, code, createdate, description)
VALUES (9, 'MPP_OPUS_EXP_SPEC', CURRENT_TIMESTAMP() , 'Access to OPUS system special export');
INSERT INTO systemrightjpa (id, code, createdate, description)
VALUES (10, 'INTEGR_ACCESS', CURRENT_TIMESTAMP() , 'System access via REST API');
INSERT INTO systemrightjpa (id, code, createdate, description)
VALUES (11, 'PROD_R_ALL', CURRENT_TIMESTAMP() , 'Read-only access to all profile''s details');
INSERT INTO systemrightjpa (id, code, createdate, description)
VALUES (12, 'PROD_W_ALL', CURRENT_TIMESTAMP() , 'Modification access to all profile''s details');
INSERT INTO systemrightjpa (id, code, createdate, description)
VALUES (13, 'DISCOUNT_R', CURRENT_TIMESTAMP() , 'Read-only access to discount''s details');
INSERT INTO systemrightjpa (id, code, createdate, description)
VALUES (14, 'DISCOUNT_W', CURRENT_TIMESTAMP() , 'Modification access to discount''s details');
INSERT INTO systemrightjpa (id, code, createdate, description)
VALUES (15, 'ICONREPO_R', CURRENT_TIMESTAMP() , 'Read-only access to icons repository');
INSERT INTO systemrightjpa (id, code, createdate, description)
VALUES (16, 'ICONREPO_W', CURRENT_TIMESTAMP() , 'Modification access to icons repository');
INSERT INTO systemrightjpa (id, code, createdate, description)
VALUES (17, 'CONF_PARAMS_R', CURRENT_TIMESTAMP() , 'Read-only access to configuration parameters');
INSERT INTO systemrightjpa (id, code, createdate, description)
VALUES (18, 'CONF_PARAMS_W', CURRENT_TIMESTAMP() , 'Modification access to configuration parameters');
INSERT INTO systemrightjpa (id, code, createdate, description)
VALUES (19, 'PROFILER_ACCESS', CURRENT_TIMESTAMP() , 'Access to Hyperon profilers');
INSERT INTO systemrightjpa (id, code, createdate, description)
VALUES (20, 'EMERG_REGION_VERSION_ROLLBACK', CURRENT_TIMESTAMP() , 'Access to active region version emergency rollback');
INSERT INTO systemrightjpa (id, code, createdate, description)
VALUES (21, 'IMPORT_OPUS_LOGS_READ', CURRENT_TIMESTAMP() , 'Access to OPUS logs');
INSERT INTO systemrightjpa (id, code, createdate, description)
VALUES (22, 'SYSCONFIG_USERS_R', CURRENT_TIMESTAMP() , 'Read-only access to user''s list');
INSERT INTO systemrightjpa (id, code, createdate, description)
VALUES (23, 'SYSCONFIG_USERS_W', CURRENT_TIMESTAMP() , 'Modification access to user''s details');
INSERT INTO systemrightjpa (id, code, createdate, description)
VALUES (24, 'SYSCONFIG_ROLES_R', CURRENT_TIMESTAMP() , 'Read-only access to roles list');
INSERT INTO systemrightjpa (id, code, createdate, description)
VALUES (25, 'SYSCONFIG_ROLES_W', CURRENT_TIMESTAMP() , 'Modification access to role''s details');
INSERT INTO systemrightjpa (id, code, createdate, description)
VALUES (26, 'PAR_R_CAT_SYSTEM', CURRENT_TIMESTAMP() , 'Read access to system params');
INSERT INTO systemrightjpa (id, code, createdate, description)
VALUES (27, 'PAR_W_CAT_SYSTEM', CURRENT_TIMESTAMP() , 'Write access to system params');
INSERT INTO systemrightjpa (id, code, createdate, description)
VALUES (28, 'SUPERPACK_IMPORT', CURRENT_TIMESTAMP() , 'Access to Superpack import');
INSERT INTO systemrightjpa (id, code, createdate, description)
VALUES (29, 'HYPERON_STUDIO_MODIFICATION', CURRENT_TIMESTAMP() , 'Access to modification in Hyperon Studio');
INSERT INTO systemrightjpa (id, code, createdate, description)
VALUES (30, 'CONTEXT_W_REMOVAL', CURRENT_TIMESTAMP() , 'Single-click context removal');
INSERT INTO systemrightjpa (id, code, createdate, description)
VALUES (31, 'DOMAIN_CONF_W_REMOVAL', CURRENT_TIMESTAMP() , 'Single-click Domain Definition removal');
INSERT INTO systemrightjpa (id, code, createdate, description)
VALUES (32, 'DOMAIN_DEF_W_REMOVAL', CURRENT_TIMESTAMP() , 'Single-click Domain Configuration removal');
INSERT INTO systemrightjpa (id, code, createdate, description)
VALUES (33, 'JWT_ACCESS', CURRENT_TIMESTAMP() , 'Access to the JWT generation view for all users');

INSERT INTO systemrolejpa (id, code, createdate, description)
VALUES (1, 'MPP_ADMIN', CURRENT_TIMESTAMP() , 'Hyperon administrator');
INSERT INTO systemrolejpa (id, code, createdate, description)
VALUES (2, 'MPP_USER', CURRENT_TIMESTAMP() , 'Hyperon user');
INSERT INTO systemrolejpa (id, code, createdate, description)
VALUES (3, 'MPP_INTEGRATION', CURRENT_TIMESTAMP() , 'Integration access');
INSERT INTO systemrolejpa (id, code, createdate, description)
VALUES (4, 'MPP_OPUS_EXPORT', CURRENT_TIMESTAMP() , 'Configuration export to OPUS');
INSERT INTO systemrolejpa (id, code, createdate, description)
VALUES (5, 'MPP_USER_READONLY', CURRENT_TIMESTAMP() , 'Read-only Hyperon user');
INSERT INTO systemrolejpa (id, code, createdate, description)
VALUES (6, 'MPP_SYSTEM_SCHEDULER', CURRENT_TIMESTAMP() , 'System scheduler');
INSERT INTO systemrolejpa (id, code, createdate, description)
VALUES (7, 'HYPERON_SUPERPACK_IMPORT', CURRENT_TIMESTAMP() , 'User with Superpack import grants');

INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (1, 1);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (2, 1);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (5, 1);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (7, 1);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (1, 2);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (1, 3);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (1, 4);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (2, 4);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (5, 4);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (1, 5);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (2, 5);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (1, 6);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (5, 6);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (7, 6);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (1, 7);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (1, 8);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (4, 8);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (1, 9);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (4, 9);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (1, 10);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (3, 10);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (1, 11);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (5, 11);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (7, 11);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (1, 12);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (1, 13);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (2, 13);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (5, 13);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (7, 13);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (1, 14);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (2, 14);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (1, 15);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (2, 15);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (5, 15);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (1, 16);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (2, 16);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (1, 17);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (2, 17);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (5, 17);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (7, 17);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (1, 18);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (2, 18);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (1, 19);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (2, 19);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (5, 19);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (7, 19);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (1, 20);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (1, 21);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (2, 21);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (5, 21);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (1, 22);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (1, 23);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (1, 24);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (1, 25);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (7, 25);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (6, 26);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (6, 27);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (1, 28);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (7, 28);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (1, 29);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (2, 29);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (1, 30);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (1, 31);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (1, 32);
INSERT INTO systemrolejpa_systemrightjpa (roles_id, rights_id)
VALUES (1, 33);

INSERT INTO systemuserjpa (id, createdate, email, firstname, lastname, login, PASSWORD, status, lastupdate, password_status)
VALUES (1, CURRENT_TIMESTAMP() , 'root@decerto.pl', 'Admin', 'Admin', 'admin',
        '{bcrypt}$2a$05$ZOGCNYNun1jIdpN0Ofqe9.hv/4VVNWSwvQCXmxelqItaduokkV9pu', 'ACTIVE', null, 'PRE_SET');
INSERT INTO systemuserjpa (id, createdate, email, firstname, lastname, login, PASSWORD, status, lastupdate, password_status)
VALUES (2, CURRENT_TIMESTAMP() , 'scheduler@system', 'Scheduler', 'System', 'system.scheduler', '!', 'ACTIVE', CURRENT_TIMESTAMP() ,
        'PRE_SET');

INSERT INTO systemuserjpa_systemrolejpa (users_id, roles_id)
VALUES (1, 1);
INSERT INTO systemuserjpa_systemrolejpa (users_id, roles_id)
VALUES (2, 6);

INSERT INTO worksession (id, description, enddate, startdate, status, username, lastupdate, expiryDate, remoteSession)
VALUES (1, ' ', CURRENT_TIMESTAMP() , CURRENT_TIMESTAMP() , 'PUBLISHED', 'admin', CURRENT_TIMESTAMP() , null, false);