/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.instrument.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cloud.sleuth.instrument.cassandra.TraceCqlSession;

public class TraceCqlSessionBeanPostProcessor
implements BeanPostProcessor {
    private final BeanFactory beanFactory;

    public TraceCqlSessionBeanPostProcessor(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        if (bean instanceof CqlSession) {
            return this.create((CqlSession)bean);
        }
        return bean;
    }

    private CqlSession create(CqlSession session) {
        return TraceCqlSession.create((CqlSession)session, (BeanFactory)this.beanFactory);
    }
}

