/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.rest.cache;

import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.caffeine.CaffeineCache;
import org.springframework.cache.support.SimpleCacheManager;

public class RestApiCacheManager
extends SimpleCacheManager {
    private static final Logger log = LoggerFactory.getLogger(RestApiCacheManager.class);
    public static final String CACHE_JWT_LOAD_USER = "jwt-load-user";
    public static final String CACHE_JWT_LOAD_TOKEN = "jwt-load-token";
    public static final String CACHE_JWT_PARSE_TOKEN = "jwt-parse-token";
    private Caffeine<Object, Object> defaultBuilder = Caffeine.newBuilder().recordStats().maximumSize(1000L).expireAfterWrite(3L, TimeUnit.MINUTES);

    protected Cache getMissingCache(String name) {
        log.info("creating missing cache [{}] with default conf: {}", (Object)name, this.defaultBuilder);
        return new CaffeineCache(name, this.defaultBuilder.build());
    }

    public void setDefaultBuilder(Caffeine<Object, Object> defaultBuilder) {
        if (defaultBuilder != null) {
            this.defaultBuilder = defaultBuilder;
        }
    }
}

