/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.rest.configuration.security.jwt;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Service;
import pl.decerto.hyperon.common.security.dao.JwtTokenDao;
import pl.decerto.hyperon.common.security.domain.JwtToken;
import pl.decerto.hyperon.common.security.domain.TokenType;
import pl.decerto.hyperon.rest.cache.CacheValue;
import pl.decerto.hyperon.rest.configuration.security.jwt.JwtTokenParser;
import pl.decerto.hyperon.rest.configuration.security.jwt.JwtUserDetailsService;

@Service
@ConditionalOnProperty(name={"higson.runtime-rest.security.type"}, havingValue="jwt", matchIfMissing=true)
public class JwtAuthFacade {
    private static final Logger log = LoggerFactory.getLogger(JwtAuthFacade.class);
    private final JwtTokenDao jwtTokenDao;
    private final JwtTokenParser jwtTokenParser;
    private final JwtUserDetailsService jwtUserDetailsService;

    @Cacheable(value={"jwt-load-token"})
    public CacheValue getJwtToken(String token) {
        JwtToken jwtToken = this.jwtTokenDao.findByTokenAndTokenType(token, TokenType.RUNTIME_REST_TOKEN).orElse(null);
        return new CacheValue(jwtToken);
    }

    @Cacheable(value={"jwt-parse-token"})
    public Jws<Claims> getClaims(String token) {
        return this.jwtTokenParser.parse(token);
    }

    @Cacheable(value={"jwt-load-user"})
    public UserDetails loadUser(Jws<Claims> claims) {
        return this.jwtUserDetailsService.loadUser(claims);
    }

    public JwtAuthFacade(JwtTokenDao jwtTokenDao, JwtTokenParser jwtTokenParser, JwtUserDetailsService jwtUserDetailsService) {
        this.jwtTokenDao = jwtTokenDao;
        this.jwtTokenParser = jwtTokenParser;
        this.jwtUserDetailsService = jwtUserDetailsService;
    }
}

