/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.rest.domain;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import pl.decerto.hyperon.rest.domain.DomainController;
import pl.decerto.hyperon.rest.domain.DomainService;
import pl.decerto.hyperon.rest.domain.GetAllPathsResponse;

@RestController
@RequestMapping(value={"/domain"}, produces={"application/json", "application/x-protobuf"})
@Tag(name="Domain", description="Endpoint related to domain")
public class DomainControllerSpringImpl
implements DomainController {
    private static final Logger log = LoggerFactory.getLogger(DomainControllerSpringImpl.class);
    private final DomainService domainService;

    @Override
    @Operation(summary="Get all domain paths", description="Get all available domain paths from given profile")
    @GetMapping(value={"/{profileCode}/paths"})
    public GetAllPathsResponse getAllPaths(@Schema(description="profile code from which domain will be taken", required=true) @PathVariable(value="profileCode") String profileCode) {
        log.debug("getting all domain paths in profile:{}", (Object)profileCode);
        Collection<String> paths = this.domainService.getAll(profileCode);
        log.debug("got {} paths", (Object)paths.size());
        return new GetAllPathsResponse(paths);
    }

    public DomainControllerSpringImpl(DomainService domainService) {
        this.domainService = domainService;
    }
}

