/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.rest.profiler;

import io.higson.runtime.profiler.engine.AttributeEngineProfiler;
import io.higson.runtime.profiler.engine.EngineProfiler;
import io.higson.runtime.profiler.jdbc.JdbcProfiler;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import pl.decerto.hyperon.rest.profiler.ProfilerController;
import pl.decerto.hyperon.rest.profiler.model.DomainAttributeStatsResponse;
import pl.decerto.hyperon.rest.profiler.model.FunctionStatsResponse;
import pl.decerto.hyperon.rest.profiler.model.JdbcStatsResponse;
import pl.decerto.hyperon.rest.profiler.model.ParameterStatsResponse;

@RestController
@RequestMapping(value={"/profiler"}, produces={"application/json", "application/x-protobuf"})
@Tag(name="Profiler", description="Endpoint related to Higson profilers")
public class ProfilerControllerSpringImpl
implements ProfilerController {
    private static final Logger log = LoggerFactory.getLogger(ProfilerControllerSpringImpl.class);

    @Override
    @GetMapping(value={"/jdbc"})
    @Operation(summary="Get JDBC stats", description="Get all stats related to JDBC queries")
    public JdbcStatsResponse getJdbcProfilerStats() {
        JdbcProfiler profiler = JdbcProfiler.getSingleton();
        List queryStats = profiler.getQueryStats();
        return new JdbcStatsResponse(queryStats, profiler.getEventsCount());
    }

    @Override
    @GetMapping(value={"/parameter"})
    @Operation(summary="Get parameter stats", description="Get all stats related to Higson parameters")
    public ParameterStatsResponse getParameterProfiler() {
        List invokeStats = EngineProfiler.PARAMETER.getInvokeStats();
        List loadStats = EngineProfiler.PARAMETER.getLoadStats();
        return new ParameterStatsResponse(invokeStats, loadStats);
    }

    @Override
    @GetMapping(value={"/function"})
    @Operation(summary="Get function stats", description="Get all stats related to higson functions")
    public FunctionStatsResponse getFunctionProfiler() {
        List invokeStats = EngineProfiler.FUNCTION.getInvokeStats();
        List loadStats = EngineProfiler.FUNCTION.getLoadStats();
        return new FunctionStatsResponse(invokeStats, loadStats);
    }

    @Override
    @GetMapping(value={"/domain/attr"})
    @Operation(summary="Get domain attribute stats", description="Get all stats related to Higson domain attributes")
    public DomainAttributeStatsResponse getDomainAttributeProfiler() {
        List invokeStats = AttributeEngineProfiler.DOMAIN.getInvokeStats();
        List loadStats = AttributeEngineProfiler.DOMAIN.getLoadStats();
        return new DomainAttributeStatsResponse(invokeStats, loadStats);
    }
}

