/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.brave.instrument.messaging;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XAJMSContext;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.brave.instrument.messaging.LazyConnectionFactory;
import org.springframework.cloud.sleuth.brave.instrument.messaging.LazyXAConnectionFactory;

class LazyConnectionAndXaConnectionFactory
implements ConnectionFactory,
XAConnectionFactory {
    private final ConnectionFactory connectionFactoryDelegate;
    private final XAConnectionFactory xaConnectionFactoryDelegate;

    LazyConnectionAndXaConnectionFactory(BeanFactory beanFactory, ConnectionFactory connectionFactoryDelegate, XAConnectionFactory xaConnectionFactoryDelegate) {
        this.connectionFactoryDelegate = new LazyConnectionFactory(beanFactory, connectionFactoryDelegate);
        this.xaConnectionFactoryDelegate = new LazyXAConnectionFactory(beanFactory, xaConnectionFactoryDelegate);
    }

    public Connection createConnection() throws JMSException {
        return this.connectionFactoryDelegate.createConnection();
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        return this.connectionFactoryDelegate.createConnection(userName, password);
    }

    public JMSContext createContext() {
        return this.connectionFactoryDelegate.createContext();
    }

    public JMSContext createContext(String userName, String password) {
        return this.connectionFactoryDelegate.createContext(userName, password);
    }

    public JMSContext createContext(String userName, String password, int sessionMode) {
        return this.connectionFactoryDelegate.createContext(userName, password, sessionMode);
    }

    public JMSContext createContext(int sessionMode) {
        return this.connectionFactoryDelegate.createContext(sessionMode);
    }

    public XAConnection createXAConnection() throws JMSException {
        return this.xaConnectionFactoryDelegate.createXAConnection();
    }

    public XAConnection createXAConnection(String userName, String password) throws JMSException {
        return this.xaConnectionFactoryDelegate.createXAConnection(userName, password);
    }

    public XAJMSContext createXAContext() {
        return this.xaConnectionFactoryDelegate.createXAContext();
    }

    public XAJMSContext createXAContext(String userName, String password) {
        return this.xaConnectionFactoryDelegate.createXAContext(userName, password);
    }
}

