/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import pl.decerto.hyperon.common.security.AuthoritiesCache;
import pl.decerto.hyperon.common.security.UserDetailsAdditionalHolder;
import pl.decerto.hyperon.common.security.cache.UserCacheEntry;
import pl.decerto.hyperon.common.security.domain.UserStatus;
import pl.decerto.hyperon.common.security.dto.SystemUser;
import pl.decerto.hyperon.common.security.dto.SystemUserPreference;

public class MppUserDetails
implements UserDetails {
    private static final Logger log = LoggerFactory.getLogger(MppUserDetails.class);
    private static final long serialVersionUID = -449783697128600774L;
    private static final String PARAM_WRITE_RIGHT_PREFIX = "PAR_W";
    private transient SystemUser user;
    private transient UserCacheEntry userCacheEntry;
    private transient UserDetailsAdditionalHolder userDetailsAdditionalHolder;

    public MppUserDetails(SystemUser user, UserCacheEntry userCacheEntry, UserDetailsAdditionalHolder userDetailsAdditionalHolder) {
        this.user = user;
        this.userCacheEntry = userCacheEntry;
        this.userDetailsAdditionalHolder = userDetailsAdditionalHolder;
    }

    public static MppUserDetails createMppUserDetails(SystemUser user, UserCacheEntry userCacheEntry) {
        return new MppUserDetails(user, userCacheEntry, null);
    }

    public static MppUserDetails createMppUserDetailsWithAdditionalDetails(SystemUser user, UserCacheEntry userCacheEntry, UserDetailsAdditionalHolder userDetailsAdditionalHolder) {
        return new MppUserDetails(user, userCacheEntry, userDetailsAdditionalHolder);
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
        if (this.userCacheEntry == null) {
            return authorities;
        }
        for (String right : this.userCacheEntry.getRights()) {
            authorities.add(AuthoritiesCache.getAuthority(right));
        }
        return authorities;
    }

    public Optional<SystemUserPreference> getPreference(String userPreference) {
        if (this.userCacheEntry == null) {
            return Optional.empty();
        }
        String value = this.userCacheEntry.getPreference(userPreference);
        if (StringUtils.isBlank((CharSequence)value)) {
            return Optional.empty();
        }
        SystemUserPreference result = new SystemUserPreference();
        result.setKey(userPreference);
        result.setValue(value);
        return Optional.of(result);
    }

    public void refresh(SystemUser userUpdated, UserCacheEntry userCacheEntry) {
        this.user = userUpdated;
        this.userCacheEntry = userCacheEntry;
    }

    public String getPassword() {
        return this.user.getPassword();
    }

    public String getUsername() {
        return this.user.getLogin();
    }

    public boolean isAccountNonExpired() {
        return this.userDetailsAdditionalHolder == null || this.userDetailsAdditionalHolder.isAccountNonExpired();
    }

    public boolean isAccountNonLocked() {
        return this.userDetailsAdditionalHolder != null ? this.userDetailsAdditionalHolder.isAccountNonLocked() : this.user.getStatus() == UserStatus.ACTIVE;
    }

    public boolean isCredentialsNonExpired() {
        return this.userDetailsAdditionalHolder == null || this.userDetailsAdditionalHolder.isCredentialsNonExpired();
    }

    public boolean isEnabled() {
        return this.userDetailsAdditionalHolder == null || this.userDetailsAdditionalHolder.isEnabled();
    }

    public boolean hasRight(String right) {
        if (Objects.isNull(this.userCacheEntry)) {
            log.trace("User cache entry is null.");
            return false;
        }
        boolean hasRight = this.userCacheEntry.hasRight(right);
        if (hasRight) {
            return true;
        }
        log.trace("User does not have correct rights. Expected right {}, {}", (Object)right, (Object)this.userCacheEntry.getId());
        return false;
    }

    private boolean canReadAnyACParam() {
        return this.userCacheEntry.canReadAnyACParam();
    }

    private boolean canReadNoACParam() {
        return this.userCacheEntry.canReadNoACParams();
    }

    boolean canReadAnyParam() {
        return this.canReadAnyACParam() || this.canReadNoACParam();
    }

    boolean hasAnyParamWriteRight() {
        return this.userCacheEntry.getRights().stream().anyMatch(right -> right.startsWith(PARAM_WRITE_RIGHT_PREFIX));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MppUserDetails that = (MppUserDetails)o;
        return Objects.equals(this.user, that.user) && Objects.equals(this.userCacheEntry, that.userCacheEntry);
    }

    public int hashCode() {
        return Objects.hash(this.user, this.userCacheEntry);
    }

    public SystemUser getUser() {
        return this.user;
    }

    public void setUser(SystemUser user) {
        this.user = user;
    }

    public UserCacheEntry getUserCacheEntry() {
        return this.userCacheEntry;
    }
}

