/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.security;

import org.springframework.stereotype.Component;
import pl.decerto.hyperon.common.security.domain.SystemRightJPA;
import pl.decerto.hyperon.common.security.domain.SystemRoleJPA;
import pl.decerto.hyperon.common.security.domain.SystemUserJPA;
import pl.decerto.hyperon.common.security.dto.SystemRightDto;
import pl.decerto.hyperon.common.security.dto.SystemRole;
import pl.decerto.hyperon.common.security.dto.SystemUser;
import pl.decerto.hyperon.common.security.mapper.SystemRightMapper;
import pl.decerto.hyperon.common.security.mapper.SystemUserMapper;

@Component
public class SystemRoleConverter {
    private final SystemUserMapper systemUserMapper;
    private final SystemRightMapper systemRightMapper;

    public SystemRoleConverter(SystemUserMapper systemUserMapper, SystemRightMapper systemRightMapper) {
        this.systemUserMapper = systemUserMapper;
        this.systemRightMapper = systemRightMapper;
    }

    public SystemRole toDto(SystemRoleJPA model) {
        if (model == null) {
            return null;
        }
        SystemRole dto = new SystemRole();
        dto.setId(model.getId());
        dto.setCode(model.getCode());
        dto.setDescription(model.getDescription());
        dto.setCreateDate(model.getCreateDate());
        for (SystemUserJPA userJPA : model.getUsers()) {
            SystemUser systemUser = this.systemUserMapper.toDto(userJPA);
            dto.addUser(systemUser);
        }
        for (SystemRightJPA rightJPA : model.getRights()) {
            SystemRightDto rightDto = this.systemRightMapper.toDto(rightJPA);
            dto.addRight(rightDto);
        }
        return dto;
    }

    public SystemRoleJPA toModel(SystemRole dto) {
        SystemRoleJPA model = new SystemRoleJPA();
        model.setId(dto.getId());
        model.setCode(dto.getCode());
        model.setDescription(dto.getDescription());
        model.setCreateDate(dto.getCreateDate());
        for (SystemUser systemUser : dto.getUsers()) {
            SystemUserJPA systemUserJPA = this.systemUserMapper.toModel(systemUser);
            model.addUser(systemUserJPA);
        }
        for (SystemRightDto systemRightDto : dto.getRights()) {
            SystemRightJPA systemRightJPA = this.systemRightMapper.toEntity(systemRightDto);
            model.addRight(systemRightJPA);
        }
        return model;
    }
}

