/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.security.cache;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import pl.decerto.hyperon.common.profiler.annotation.Profiling;
import pl.decerto.hyperon.common.security.cache.UserCacheEntry;
import pl.decerto.hyperon.common.security.dao.UserJdbcDao;

@Service
@Profiling(profilerName="userCache")
public class UsersCacheManager {
    private static final Logger log = LoggerFactory.getLogger(UsersCacheManager.class);
    private final UserJdbcDao dao;
    private Map<String, UserCacheEntry> loginCache = new ConcurrentHashMap<String, UserCacheEntry>();

    @Autowired
    public UsersCacheManager(UserJdbcDao dao) {
        this.dao = dao;
    }

    public void invalidate() {
        this.loginCache.clear();
    }

    public void invalidate(String login) {
        this.loginCache.remove(login);
    }

    public UserCacheEntry getUserCacheEntry(String login) {
        this.reloadCache(login);
        if (this.loginCache.containsKey(login)) {
            return this.loginCache.get(login);
        }
        return null;
    }

    public boolean hasRight(String login, String rightCode) {
        this.reloadCache(login);
        if (this.loginCache.containsKey(login)) {
            return this.loginCache.get(login).hasRight(rightCode);
        }
        return false;
    }

    public String getCurrentProfile(String login) {
        this.reloadCache(login);
        return this.loginCache.containsKey(login) ? this.loginCache.get(login).getCurrentProfile() : null;
    }

    private void reloadCache(String login) {
        if (Objects.nonNull(login) && !this.loginCache.containsKey(login)) {
            log.info("reloading user cache for user {}", (Object)login);
            UserCacheEntry user = this.reloadUser(login);
            if (user != null) {
                this.loginCache.put(login, user);
            }
        }
    }

    private UserCacheEntry reloadUser(String login) {
        UserCacheEntry dto = this.dao.getUserRights(login);
        if (dto.getId() == 0) {
            return null;
        }
        this.dao.getUserPreferences(dto);
        return dto;
    }

    public void reloadPreferences(String login) {
        log.info("reloading preferences for {}", (Object)login);
        UserCacheEntry current = this.loginCache.get(login);
        if (current != null) {
            this.dao.getUserPreferences(current);
        } else {
            this.reloadCache(login);
        }
    }

    public void addPreference(String login, String key, String value) {
        this.reloadCache(login);
        UserCacheEntry current = this.loginCache.get(login);
        if (current != null) {
            current.addPreference(key, value);
        }
    }
}

