/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.security.dto;

import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.validator.constraints.Email;
import pl.decerto.hyperon.common.security.domain.PasswordStatus;
import pl.decerto.hyperon.common.security.domain.UserStatus;
import pl.decerto.hyperon.common.security.dto.SystemRole;
import pl.decerto.hyperon.common.security.dto.SystemUserPreference;

public class SystemUser {
    private int id;
    @Size(min=1, max=200, message="{common.incorrect.name.length}")
    private @Size(min=1, max=200, message="{common.incorrect.name.length}") String login = "";
    private String password = "";
    private PasswordStatus passwordStatus;
    @Size(min=1, message="{common.notNull}")
    private @Size(min=1, message="{common.notNull}") String firstName = "";
    @Size(min=1, message="{common.notNull}")
    private @Size(min=1, message="{common.notNull}") String lastName = "";
    @NotNull(message="{common.notNull}")
    @Size(min=1, message="{common.notNull}")
    @Email(message="{common.incorrectEmail}")
    private @NotNull(message="{common.notNull}") @Size(min=1, message="{common.notNull}") @Email(message="{common.incorrectEmail}") String email;
    private Date createDate;
    private UserStatus status;
    private Set<SystemRole> roles = new HashSet<SystemRole>();
    private Set<SystemUserPreference> preferences = new HashSet<SystemUserPreference>();

    public void addRole(SystemRole role) {
        this.roles.add(role);
    }

    public void addPreference(SystemUserPreference preference) {
        this.preferences.add(preference);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        if (this.id > 0) {
            result = 31 * result + this.id;
        } else {
            result = 31 * result + (this.email == null ? 0 : this.email.hashCode());
            result = 31 * result + (this.firstName == null ? 0 : this.firstName.hashCode());
            result = 31 * result + (this.lastName == null ? 0 : this.lastName.hashCode());
            result = 31 * result + (this.login == null ? 0 : this.login.hashCode());
            result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
            result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SystemUser other = (SystemUser)obj;
        if (this.id > 0) {
            return this.id == other.id;
        }
        if (this.email == null ? other.email != null : !this.email.equals(other.email)) {
            return false;
        }
        if (this.firstName == null ? other.firstName != null : !this.firstName.equals(other.firstName)) {
            return false;
        }
        if (this.lastName == null ? other.lastName != null : !this.lastName.equals(other.lastName)) {
            return false;
        }
        if (this.login == null ? other.login != null : !this.login.equals(other.login)) {
            return false;
        }
        if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
            return false;
        }
        return this.status == other.status;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public boolean isNewObject() {
        return this.id == 0;
    }

    public boolean nothingChanged(SystemUser other) {
        if (this.email == null ? other.email != null : !this.email.equals(other.email)) {
            return false;
        }
        if (this.firstName == null ? other.firstName != null : !this.firstName.equals(other.firstName)) {
            return false;
        }
        if (this.lastName == null ? other.lastName != null : !this.lastName.equals(other.lastName)) {
            return false;
        }
        if (this.login == null ? other.login != null : !this.login.equals(other.login)) {
            return false;
        }
        if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
            return false;
        }
        if (this.status != other.status) {
            return false;
        }
        if (other.roles.size() != this.roles.size()) {
            return false;
        }
        for (SystemRole role : this.roles) {
            boolean equal = false;
            for (SystemRole otherRole : other.roles) {
                if (!role.getCode().equals(otherRole.getCode())) continue;
                equal = true;
                break;
            }
            if (equal) continue;
            return false;
        }
        return true;
    }

    public Set<String> getRoleCodes() {
        return this.getRoles().stream().map(SystemRole::getCode).collect(Collectors.toSet());
    }

    public String print() {
        return "SystemUser[#" + this.id + "/" + this.login + ", email=" + this.email + ", roles=" + this.getRoleCodes() + "]";
    }

    public int getId() {
        return this.id;
    }

    public String getLogin() {
        return this.login;
    }

    public PasswordStatus getPasswordStatus() {
        return this.passwordStatus;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public UserStatus getStatus() {
        return this.status;
    }

    public Set<SystemRole> getRoles() {
        return this.roles;
    }

    public Set<SystemUserPreference> getPreferences() {
        return this.preferences;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public void setPasswordStatus(PasswordStatus passwordStatus) {
        this.passwordStatus = passwordStatus;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public void setStatus(UserStatus status) {
        this.status = status;
    }

    public void setRoles(Set<SystemRole> roles) {
        this.roles = roles;
    }

    public void setPreferences(Set<SystemUserPreference> preferences) {
        this.preferences = preferences;
    }

    public String toString() {
        return "SystemUser(id=" + this.getId() + ", login=" + this.getLogin() + ", email=" + this.getEmail() + ", createDate=" + this.getCreateDate() + ", status=" + this.getStatus() + ")";
    }
}

