/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.security.oauth2;

import jakarta.annotation.PostConstruct;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import pl.decerto.hyperon.common.security.oauth2.OAuth2PropertyCondition;
import pl.decerto.hyperon.common.security.oauth2.OAuth2PropertyException;

@OAuth2PropertyCondition
@ConfigurationProperties(value="higson.studio.security.oauth2")
public class HyperonSecurityOAuth2Properties {
    private static final Logger log = LoggerFactory.getLogger(HyperonSecurityOAuth2Properties.class);
    private static final String REDIRECT_URI = "{baseUrl}/login/oauth2/code/{registrationId}";
    private List<Client> clients;
    private final List<ClientRegistration> clientRegistrations;

    public HyperonSecurityOAuth2Properties(List<Client> clients) {
        this.clients = clients;
        this.clientRegistrations = this.clients.stream().map(Client::toClientRegistration).collect(Collectors.toList());
    }

    @PostConstruct
    void log() {
        log.trace("clients {}", this.clients);
    }

    public String toString() {
        return "HyperonOAuthProperties{clients=" + this.clients + "}";
    }

    public List<Client> getClients() {
        return this.clients;
    }

    public List<ClientRegistration> getClientRegistrations() {
        return this.clientRegistrations;
    }

    public void setClients(List<Client> clients) {
        this.clients = clients;
    }

    public static class Client {
        private static final Map<String, AuthorizationGrantType> SUPPORTED_GRANT_TYPES = Map.of(AuthorizationGrantType.REFRESH_TOKEN.getValue(), AuthorizationGrantType.REFRESH_TOKEN, AuthorizationGrantType.CLIENT_CREDENTIALS.getValue(), AuthorizationGrantType.CLIENT_CREDENTIALS, AuthorizationGrantType.PASSWORD.getValue(), AuthorizationGrantType.PASSWORD, "jwt_bearer", AuthorizationGrantType.JWT_BEARER, AuthorizationGrantType.AUTHORIZATION_CODE.getValue(), AuthorizationGrantType.AUTHORIZATION_CODE);
        private static final Map<String, ClientAuthenticationMethod> SUPPORTED_AUTH_METHODS = Map.of(ClientAuthenticationMethod.CLIENT_SECRET_BASIC.getValue(), ClientAuthenticationMethod.CLIENT_SECRET_BASIC, ClientAuthenticationMethod.CLIENT_SECRET_JWT.getValue(), ClientAuthenticationMethod.CLIENT_SECRET_JWT, ClientAuthenticationMethod.PRIVATE_KEY_JWT.getValue(), ClientAuthenticationMethod.PRIVATE_KEY_JWT);
        private String registrationId;
        private String issuer;
        private String clientId;
        private String clientSecret;
        private String authorizationGrantType;
        private String authorizationMethod;
        private List<String> scopes;
        private String clientName;
        private String tokenUri;
        private String authorizationEndpoint;
        private String userinfo;
        private String jwkUri;
        private String tokenLiveTime;

        private ClientRegistration toClientRegistration() {
            return ClientRegistration.withRegistrationId((String)this.registrationId).clientId(this.clientId).clientSecret(this.clientSecret).clientName(this.clientName).clientAuthenticationMethod(this.clientAuthenticationMethod()).authorizationGrantType(this.authorizationGrantType()).userNameAttributeName("sub").redirectUri(HyperonSecurityOAuth2Properties.REDIRECT_URI).scope(this.scopes).authorizationUri(this.issuer + this.authorizationEndpoint).userInfoUri(this.issuer + this.userinfo).tokenUri(this.issuer + this.tokenUri).jwkSetUri(this.issuer + this.jwkUri).build();
        }

        private AuthorizationGrantType authorizationGrantType() {
            return Optional.ofNullable(SUPPORTED_GRANT_TYPES.get(this.authorizationGrantType.toLowerCase())).orElseThrow(() -> new OAuth2PropertyException("authorization grant type", this.authorizationGrantType, SUPPORTED_GRANT_TYPES.keySet()));
        }

        private ClientAuthenticationMethod clientAuthenticationMethod() {
            return Optional.ofNullable(SUPPORTED_AUTH_METHODS.get(this.authorizationMethod.toLowerCase())).orElseThrow(() -> new OAuth2PropertyException("authorization method", this.authorizationMethod, SUPPORTED_AUTH_METHODS.keySet()));
        }

        public void setRegistrationId(String registrationId) {
            this.registrationId = registrationId;
        }

        public void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        public void setAuthorizationGrantType(String authorizationGrantType) {
            this.authorizationGrantType = authorizationGrantType;
        }

        public void setAuthorizationMethod(String authorizationMethod) {
            this.authorizationMethod = authorizationMethod;
        }

        public void setScopes(List<String> scopes) {
            this.scopes = scopes;
        }

        public void setClientName(String clientName) {
            this.clientName = clientName;
        }

        public void setTokenUri(String tokenUri) {
            this.tokenUri = tokenUri;
        }

        public void setAuthorizationEndpoint(String authorizationEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
        }

        public void setUserinfo(String userinfo) {
            this.userinfo = userinfo;
        }

        public void setJwkUri(String jwkUri) {
            this.jwkUri = jwkUri;
        }

        public void setTokenLiveTime(String tokenLiveTime) {
            this.tokenLiveTime = tokenLiveTime;
        }

        public Client(String registrationId, String issuer, String clientId, String clientSecret, String authorizationGrantType, String authorizationMethod, List<String> scopes, String clientName, String tokenUri, String authorizationEndpoint, String userinfo, String jwkUri, String tokenLiveTime) {
            this.registrationId = registrationId;
            this.issuer = issuer;
            this.clientId = clientId;
            this.clientSecret = clientSecret;
            this.authorizationGrantType = authorizationGrantType;
            this.authorizationMethod = authorizationMethod;
            this.scopes = scopes;
            this.clientName = clientName;
            this.tokenUri = tokenUri;
            this.authorizationEndpoint = authorizationEndpoint;
            this.userinfo = userinfo;
            this.jwkUri = jwkUri;
            this.tokenLiveTime = tokenLiveTime;
        }

        public String getIssuer() {
            return this.issuer;
        }

        public String getTokenLiveTime() {
            return this.tokenLiveTime;
        }
    }
}

