/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.security.oauth2;

import jakarta.servlet.Filter;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationPropertiesScan;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.oauth2.jwt.JwtClaimValidator;
import org.springframework.security.oauth2.jwt.JwtTimestampValidator;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.context.request.async.WebAsyncManagerIntegrationFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.filter.ForwardedHeaderFilter;
import pl.decerto.hyperon.common.security.oauth2.HyperonSecurityOAuth2Properties;
import pl.decerto.hyperon.common.security.oauth2.OAuth2PropertyCondition;

@Configuration
@ConfigurationPropertiesScan
@EnableConfigurationProperties
@OAuth2PropertyCondition
public class OAuth2SecurityConfiguration {
    private final HyperonSecurityOAuth2Properties properties;

    @Bean
    public ClientRegistrationRepository clientRegistrationRepository() {
        return new InMemoryClientRegistrationRepository(this.properties.getClientRegistrations());
    }

    @Bean
    public JwtClaimValidator<List<String>> audienceValidator() {
        ClientRegistration client = this.properties.getClientRegistrations().get(0);
        return new JwtClaimValidator("aud", aud -> aud.contains(client.getClientId()));
    }

    @Bean
    public JwtTimestampValidator jwtTimestampValidator() {
        HyperonSecurityOAuth2Properties.Client client = this.properties.getClients().get(0);
        long liveTime = Long.parseLong(client.getTokenLiveTime());
        Duration duration = Duration.of(liveTime, ChronoUnit.SECONDS);
        return new JwtTimestampValidator(duration);
    }

    public HyperonSecurityOAuth2Properties getProperties() {
        return this.properties;
    }

    public OAuth2SecurityConfiguration(HyperonSecurityOAuth2Properties properties) {
        this.properties = properties;
    }

    @OAuth2PropertyCondition
    public static class OAuth2LoginSecurityConfig {
        @Bean
        public SecurityFilterChain filterChain(HttpSecurity http) throws Exception {
            ForwardedHeaderFilter filter = new ForwardedHeaderFilter();
            Class<WebAsyncManagerIntegrationFilter> beforeFilter = WebAsyncManagerIntegrationFilter.class;
            http.authorizeHttpRequests(authz -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authz.requestMatchers(new RequestMatcher[]{new AntPathRequestMatcher("/login")})).permitAll().requestMatchers(new RequestMatcher[]{new AntPathRequestMatcher("/app/**")})).authenticated().requestMatchers(new RequestMatcher[]{new AntPathRequestMatcher("/api/**")})).authenticated()).oauth2Login(Customizer.withDefaults()).oauth2ResourceServer(configurer -> configurer.jwt(Customizer.withDefaults())).csrf(AbstractHttpConfigurer::disable).exceptionHandling(Customizer.withDefaults());
            http.addFilterBefore((Filter)filter, beforeFilter);
            return (SecurityFilterChain)http.build();
        }
    }
}

