/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common.processor.core;

import com.univocity.parsers.annotations.helpers.MethodFilter;
import com.univocity.parsers.common.Context;
import com.univocity.parsers.common.processor.core.AbstractBeanProcessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractBeanListProcessor<T, C extends Context>
extends AbstractBeanProcessor<T, C> {
    private List<T> beans;
    private String[] headers;

    public AbstractBeanListProcessor(Class<T> beanType) {
        super(beanType, MethodFilter.ONLY_SETTERS);
    }

    @Override
    public void beanProcessed(T bean, C context) {
        this.beans.add(bean);
    }

    public List<T> getBeans() {
        return this.beans == null ? Collections.emptyList() : this.beans;
    }

    @Override
    public void processStarted(C context) {
        super.processStarted(context);
        this.beans = new ArrayList<T>();
    }

    @Override
    public void processEnded(C context) {
        this.headers = context.headers();
        super.processEnded(context);
    }

    public String[] getHeaders() {
        return this.headers;
    }
}

