/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.jdbc;

import com.zaxxer.hikari.HikariDataSource;
import javax.sql.CommonDataSource;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.docs.AssertingSpanBuilder;
import org.springframework.cloud.sleuth.docs.DocumentedSpan;
import org.springframework.cloud.sleuth.docs.TagKey;
import org.springframework.cloud.sleuth.instrument.jdbc.SleuthJdbcSpan;
import org.springframework.cloud.sleuth.instrument.jdbc.TraceListenerStrategySpanCustomizer;
import org.springframework.util.StringUtils;

public class TraceHikariListenerStrategySpanCustomizer
implements TraceListenerStrategySpanCustomizer<HikariDataSource> {
    @Override
    public void customizeConnectionSpan(HikariDataSource hikariDataSource, Span.Builder spanBuilder) {
        AssertingSpanBuilder assertingSpanBuilder = AssertingSpanBuilder.of((DocumentedSpan)SleuthJdbcSpan.JDBC_CONNECTION_SPAN, (Span.Builder)spanBuilder);
        if (StringUtils.hasText((String)hikariDataSource.getDriverClassName())) {
            assertingSpanBuilder.tag((TagKey)SleuthJdbcSpan.ConnectionTags.DATASOURCE_DRIVER, hikariDataSource.getDriverClassName());
        }
        if (StringUtils.hasText((String)hikariDataSource.getPoolName())) {
            assertingSpanBuilder.tag((TagKey)SleuthJdbcSpan.ConnectionTags.DATASOURCE_POOL, hikariDataSource.getPoolName());
        }
    }

    @Override
    public boolean isApplicable(CommonDataSource dataSource) {
        return dataSource instanceof HikariDataSource;
    }
}

