/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.jdbc;

import com.p6spy.engine.common.ConnectionInformation;
import com.p6spy.engine.common.PreparedStatementInformation;
import com.p6spy.engine.common.ResultSetInformation;
import com.p6spy.engine.common.StatementInformation;
import com.p6spy.engine.event.SimpleJdbcEventListener;
import java.sql.SQLException;
import java.util.List;
import javax.sql.CommonDataSource;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.jdbc.DataSourceNameResolver;
import org.springframework.cloud.sleuth.instrument.jdbc.TraceListenerStrategy;
import org.springframework.cloud.sleuth.instrument.jdbc.TraceListenerStrategySpanCustomizer;
import org.springframework.cloud.sleuth.instrument.jdbc.TraceType;
import org.springframework.core.Ordered;
import org.springframework.util.StringUtils;

public class TraceJdbcEventListener
extends SimpleJdbcEventListener
implements Ordered {
    public static final int ORDER = -2147483638;
    private final DataSourceNameResolver dataSourceNameResolver;
    private final TraceListenerStrategy<ConnectionInformation, StatementInformation, ResultSetInformation> strategy;
    private final boolean includeParameterValues;

    public TraceJdbcEventListener(Tracer tracer, DataSourceNameResolver dataSourceNameResolver, List<TraceType> traceTypes, boolean includeParameterValues, List<TraceListenerStrategySpanCustomizer<? super CommonDataSource>> customizers) {
        this.dataSourceNameResolver = dataSourceNameResolver;
        this.includeParameterValues = includeParameterValues;
        this.strategy = new TraceListenerStrategy(tracer, traceTypes, customizers);
    }

    public TraceJdbcEventListener(BeanFactory beanFactory, DataSourceNameResolver dataSourceNameResolver, List<TraceType> traceTypes, boolean includeParameterValues, List<TraceListenerStrategySpanCustomizer<? super CommonDataSource>> customizers) {
        this.dataSourceNameResolver = dataSourceNameResolver;
        this.includeParameterValues = includeParameterValues;
        this.strategy = new TraceListenerStrategy(beanFactory, traceTypes, customizers);
    }

    public void onBeforeGetConnection(ConnectionInformation connectionInformation) {
        CommonDataSource dataSource = connectionInformation.getDataSource();
        String dataSourceName = this.dataSourceNameResolver.resolveDataSourceName(dataSource);
        this.strategy.beforeGetConnection(connectionInformation, dataSource, dataSourceName);
    }

    public void onAfterGetConnection(ConnectionInformation connectionInformation, SQLException e) {
        CommonDataSource dataSource = connectionInformation.getDataSource();
        String dataSourceName = this.dataSourceNameResolver.resolveDataSourceName(dataSource);
        this.strategy.afterGetConnection(connectionInformation, connectionInformation.getConnection(), dataSourceName, e);
    }

    public void onBeforeAnyExecute(StatementInformation statementInformation) {
        this.strategy.beforeQuery(statementInformation.getConnectionInformation(), statementInformation);
    }

    public void onAfterAnyExecute(StatementInformation statementInformation, long timeElapsedNanos, SQLException e) {
        this.strategy.afterQuery(statementInformation.getConnectionInformation(), statementInformation, this.getSql(statementInformation), e);
    }

    public void onBeforeResultSetNext(ResultSetInformation resultSetInformation) {
        this.strategy.beforeResultSetNext(resultSetInformation.getConnectionInformation(), resultSetInformation.getStatementInformation(), resultSetInformation);
    }

    public void onAfterExecuteUpdate(PreparedStatementInformation statementInformation, long timeElapsedNanos, int rowCount, SQLException e) {
        if (e == null) {
            this.strategy.addQueryRowCount(statementInformation.getConnectionInformation(), (StatementInformation)statementInformation, rowCount);
        }
        super.onAfterExecuteUpdate(statementInformation, timeElapsedNanos, rowCount, e);
    }

    public void onAfterExecuteUpdate(StatementInformation statementInformation, long timeElapsedNanos, String sql, int rowCount, SQLException e) {
        if (e == null) {
            this.strategy.addQueryRowCount(statementInformation.getConnectionInformation(), statementInformation, rowCount);
        }
        super.onAfterExecuteUpdate(statementInformation, timeElapsedNanos, sql, rowCount, e);
    }

    public void onAfterStatementClose(StatementInformation statementInformation, SQLException e) {
        this.strategy.afterStatementClose(statementInformation.getConnectionInformation(), statementInformation);
    }

    public void onAfterResultSetClose(ResultSetInformation resultSetInformation, SQLException e) {
        this.strategy.afterResultSetClose(resultSetInformation.getConnectionInformation(), resultSetInformation, resultSetInformation.getCurrRow() + 1, e);
    }

    public void onAfterCommit(ConnectionInformation connectionInformation, long timeElapsedNanos, SQLException e) {
        this.strategy.afterCommit(connectionInformation, e);
    }

    public void onAfterRollback(ConnectionInformation connectionInformation, long timeElapsedNanos, SQLException e) {
        this.strategy.afterRollback(connectionInformation, e);
    }

    public void onAfterConnectionClose(ConnectionInformation connectionInformation, SQLException e) {
        this.strategy.afterConnectionClose(connectionInformation, e);
    }

    private String getSql(StatementInformation statementInformation) {
        return this.includeParameterValues && StringUtils.hasText((String)statementInformation.getSqlWithValues()) ? statementInformation.getSqlWithValues() : statementInformation.getSql();
    }

    public int getOrder() {
        return -2147483638;
    }
}

