/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.rsocket;

import io.rsocket.RSocket;
import io.rsocket.core.RSocketServer;
import org.springframework.boot.rsocket.server.RSocketServerCustomizer;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.rsocket.ByteBufGetter;
import org.springframework.cloud.sleuth.instrument.rsocket.ByteBufSetter;
import org.springframework.cloud.sleuth.instrument.rsocket.TracingRequesterRSocketProxy;
import org.springframework.cloud.sleuth.instrument.rsocket.TracingResponderRSocketProxy;
import org.springframework.cloud.sleuth.propagation.Propagator;

public class TracingRSocketServerCustomizer
implements RSocketServerCustomizer {
    private final Propagator propagator;
    private final Tracer tracer;
    private final boolean isZipkinPropagationEnabled;

    public TracingRSocketServerCustomizer(Propagator propagator, Tracer tracer, boolean isZipkinPropagationEnabled) {
        this.propagator = propagator;
        this.tracer = tracer;
        this.isZipkinPropagationEnabled = isZipkinPropagationEnabled;
    }

    public void customize(RSocketServer rSocketServer) {
        rSocketServer.interceptors(ir -> ir.forResponder(rSocket -> new TracingResponderRSocketProxy((RSocket)rSocket, this.propagator, new ByteBufGetter(), this.tracer, this.isZipkinPropagationEnabled)).forRequester(rSocket -> new TracingRequesterRSocketProxy((RSocket)rSocket, this.propagator, new ByteBufSetter(), this.tracer, this.isZipkinPropagationEnabled)));
    }
}

