/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.config.parameterstore;

import io.awspring.cloud.autoconfigure.AwsClientProperties;
import io.awspring.cloud.autoconfigure.AwsSyncClientCustomizer;
import io.awspring.cloud.autoconfigure.config.AbstractAwsConfigDataLocationResolver;
import io.awspring.cloud.autoconfigure.config.parameterstore.AwsParameterStoreClientCustomizer;
import io.awspring.cloud.autoconfigure.config.parameterstore.ParameterStoreConfigDataResource;
import io.awspring.cloud.autoconfigure.config.parameterstore.ParameterStoreKeysMissingException;
import io.awspring.cloud.autoconfigure.config.parameterstore.ParameterStoreProperties;
import io.awspring.cloud.autoconfigure.config.parameterstore.ParameterStorePropertySources;
import io.awspring.cloud.autoconfigure.config.parameterstore.SsmClientCustomizer;
import io.awspring.cloud.autoconfigure.core.AwsClientCustomizer;
import io.awspring.cloud.autoconfigure.core.AwsProperties;
import io.awspring.cloud.autoconfigure.core.CredentialsProperties;
import io.awspring.cloud.autoconfigure.core.RegionProperties;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.springframework.boot.BootstrapContext;
import org.springframework.boot.context.config.ConfigDataLocation;
import org.springframework.boot.context.config.ConfigDataLocationNotFoundException;
import org.springframework.boot.context.config.ConfigDataLocationResolverContext;
import org.springframework.boot.context.config.Profiles;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.logging.DeferredLogFactory;
import software.amazon.awssdk.awscore.client.builder.AwsSyncClientBuilder;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.SsmClientBuilder;

public class ParameterStoreConfigDataLocationResolver
extends AbstractAwsConfigDataLocationResolver<ParameterStoreConfigDataResource> {
    public static final String PREFIX = "aws-parameterstore:";
    private final Log log;

    public ParameterStoreConfigDataLocationResolver(DeferredLogFactory deferredLogFactory) {
        this.log = deferredLogFactory.getLog(ParameterStoreConfigDataLocationResolver.class);
    }

    @Override
    protected String getPrefix() {
        return PREFIX;
    }

    public List<ParameterStoreConfigDataResource> resolveProfileSpecific(ConfigDataLocationResolverContext resolverContext, ConfigDataLocation location, Profiles profiles) throws ConfigDataLocationNotFoundException {
        ParameterStoreProperties properties = this.loadProperties(resolverContext.getBinder());
        ArrayList<ParameterStoreConfigDataResource> locations = new ArrayList<ParameterStoreConfigDataResource>();
        ParameterStorePropertySources sources = new ParameterStorePropertySources();
        List<String> contexts = this.getCustomContexts(location.getNonPrefixedValue(PREFIX));
        if (properties.isEnabled()) {
            this.registerBean(resolverContext, AwsProperties.class, this.loadAwsProperties(resolverContext.getBinder()));
            this.registerBean(resolverContext, ParameterStoreProperties.class, properties);
            this.registerBean(resolverContext, CredentialsProperties.class, this.loadCredentialsProperties(resolverContext.getBinder()));
            this.registerBean(resolverContext, RegionProperties.class, this.loadRegionProperties(resolverContext.getBinder()));
            this.registerAndPromoteBean(resolverContext, SsmClient.class, this::createSimpleSystemManagementClient);
            contexts.forEach(propertySourceContext -> locations.add(new ParameterStoreConfigDataResource((String)propertySourceContext, location.isOptional(), sources)));
            if (!location.isOptional() && locations.isEmpty()) {
                throw new ParameterStoreKeysMissingException("No Parameter Store keys provided in `spring.config.import=aws-parameterstore:` configuration.");
            }
        } else {
            contexts.forEach(propertySourceContext -> locations.add(new ParameterStoreConfigDataResource((String)propertySourceContext, location.isOptional(), false, sources)));
        }
        return locations;
    }

    protected SsmClient createSimpleSystemManagementClient(BootstrapContext context) {
        SsmClientBuilder builder = this.configure(SsmClient.builder(), (AwsClientProperties)context.get(ParameterStoreProperties.class), context);
        try {
            AwsParameterStoreClientCustomizer configurer = (AwsParameterStoreClientCustomizer)context.get(AwsParameterStoreClientCustomizer.class);
            if (configurer != null) {
                AwsClientCustomizer.apply(configurer, builder);
            }
        }
        catch (IllegalStateException e) {
            this.log.debug((Object)("Bean of type AwsParameterStoreClientCustomizer is not registered: " + e.getMessage()));
        }
        try {
            AwsSyncClientCustomizer awsSyncClientCustomizer = (AwsSyncClientCustomizer)context.get(AwsSyncClientCustomizer.class);
            if (awsSyncClientCustomizer != null) {
                awsSyncClientCustomizer.customize((AwsSyncClientBuilder<?, ?>)builder);
            }
        }
        catch (IllegalStateException e) {
            this.log.debug((Object)("Bean of type AwsSyncClientCustomizer is not registered: " + e.getMessage()));
        }
        try {
            SsmClientCustomizer ssmClientCustomizer = (SsmClientCustomizer)context.get(SsmClientCustomizer.class);
            if (ssmClientCustomizer != null) {
                ssmClientCustomizer.customize(builder);
            }
        }
        catch (IllegalStateException e) {
            this.log.debug((Object)("Bean of type SsmClientCustomizer is not registered: " + e.getMessage()));
        }
        return (SsmClient)builder.build();
    }

    protected ParameterStoreProperties loadProperties(Binder binder) {
        return (ParameterStoreProperties)binder.bind("spring.cloud.aws.parameterstore", Bindable.of(ParameterStoreProperties.class)).orElseGet(ParameterStoreProperties::new);
    }
}

