/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.builtin.executor;

import io.higson.runtime.builtin.executor.UtilFunctionExecutor;
import io.higson.runtime.builtin.implementation.AddUtilFunction;
import io.higson.runtime.builtin.implementation.DiffUtilFunction;
import io.higson.runtime.builtin.implementation.EqualsUtilFunction;
import io.higson.runtime.builtin.implementation.ExistUtilFunction;
import io.higson.runtime.builtin.implementation.FormatUtilFunction;
import io.higson.runtime.builtin.implementation.FromUtilFunction;
import io.higson.runtime.builtin.implementation.GetUtilFunction;
import io.higson.runtime.builtin.implementation.GreaterThanEqualsUtilFunction;
import io.higson.runtime.builtin.implementation.GreaterThanUtilFunction;
import io.higson.runtime.builtin.implementation.IsBlankUtilFunction;
import io.higson.runtime.builtin.implementation.IsEmptyUtilFunction;
import io.higson.runtime.builtin.implementation.LessThanEqualsUtilFunction;
import io.higson.runtime.builtin.implementation.LessThanUtilFunction;
import io.higson.runtime.builtin.implementation.NotBlankUtilFunction;
import io.higson.runtime.builtin.implementation.NotEmptyUtilFunction;
import io.higson.runtime.builtin.implementation.SizeUtilFunction;
import io.higson.runtime.builtin.implementation.ToUtilFunction;
import io.higson.runtime.builtin.implementation.TrimUtilFunction;
import io.higson.runtime.builtin.implementation.UtilFunction;
import io.higson.runtime.core.HigsonContext;
import io.higson.runtime.exception.HigsonRuntimeException;
import java.util.Map;
import java.util.Set;

public class UtilFunctionExecutorImpl
implements UtilFunctionExecutor {
    public static UtilFunctionExecutor INSTANCE = new UtilFunctionExecutorImpl();
    private final Map<String, UtilFunction> FUNCTION_IMPLEMENTATION = Map.ofEntries(Map.entry("get", GetUtilFunction.INSTANCE), Map.entry("exist", ExistUtilFunction.INSTANCE), Map.entry("isBlank", IsBlankUtilFunction.INSTANCE), Map.entry("notBlank", NotBlankUtilFunction.INSTANCE), Map.entry("isEmpty", IsEmptyUtilFunction.INSTANCE), Map.entry("notEmpty", NotEmptyUtilFunction.INSTANCE), Map.entry("size", SizeUtilFunction.INSTANCE), Map.entry("trim", TrimUtilFunction.INSTANCE), Map.entry("from", FromUtilFunction.INSTANCE), Map.entry("add", AddUtilFunction.INSTANCE), Map.entry("to", ToUtilFunction.INSTANCE), Map.entry("diff", DiffUtilFunction.INSTANCE), Map.entry("format", FormatUtilFunction.INSTANCE), Map.entry("equals", EqualsUtilFunction.INSTANCE), Map.entry("lt", LessThanUtilFunction.INSTANCE), Map.entry("lte", LessThanEqualsUtilFunction.INSTANCE), Map.entry("gt", GreaterThanUtilFunction.INSTANCE), Map.entry("gte", GreaterThanEqualsUtilFunction.INSTANCE));

    @Override
    public Object execute(String functionCode, HigsonContext ctx, Object[] args) {
        if (!this.FUNCTION_IMPLEMENTATION.containsKey(functionCode)) {
            throw new HigsonRuntimeException("Util function '" + functionCode + "' is not supported");
        }
        UtilFunction utilFunction = this.FUNCTION_IMPLEMENTATION.get(functionCode.trim());
        return utilFunction.call(ctx, args);
    }

    @Override
    public Set<String> supportedFunctions() {
        return this.FUNCTION_IMPLEMENTATION.keySet();
    }

    private UtilFunctionExecutorImpl() {
    }
}

