/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.core.datasource.snapshot.domain;

import io.higson.runtime.core.datasource.snapshot.SnapshotPath;
import io.higson.runtime.core.datasource.snapshot.domain.AttributeProcessor;
import io.higson.runtime.core.datasource.snapshot.domain.DomainDefinitionXmlHelper;
import io.higson.runtime.core.datasource.snapshot.domain.DomainDirectoryAnalyzer;
import io.higson.runtime.core.datasource.snapshot.domain.DomainElementAttributesWrapper;
import io.higson.runtime.core.datasource.snapshot.domain.DomainElementFactory;
import io.higson.runtime.core.datasource.snapshot.domain.DomainElementWrapper;
import io.higson.runtime.core.datasource.snapshot.domain.DomainImportFilesProcessor;
import io.higson.runtime.core.datasource.snapshot.domain.DomainReaderVisitor;
import io.higson.runtime.core.datasource.snapshot.domain.DomainWrapper;
import io.higson.runtime.core.datasource.snapshot.domain.ElementWithRegionVersion;
import io.higson.runtime.core.datasource.snapshot.domain.ImportSnapshotException;
import io.higson.runtime.core.datasource.snapshot.domain.InfoProcessor;
import io.higson.runtime.core.datasource.snapshot.domain.PathUtils;
import io.higson.runtime.core.datasource.snapshot.domain.ReferenceProcessor;
import io.higson.runtime.core.datasource.snapshot.domain.SnapshotModelConverter;
import io.higson.runtime.core.datasource.snapshot.domain.SnapshotTomlFileParser;
import io.higson.runtime.helper.snapshot.SnapshotFileHelper;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.decerto.mpp.imports.xml.domain.DomainElement;
import pl.decerto.mpp.imports.xml.domain.DomainType;
import pl.decerto.mpp.imports.xml.domain.DomainTypeCollection;

public class DomainReaderVisitorImpl
extends DomainReaderVisitor<Path> {
    private static final Logger log = LoggerFactory.getLogger(DomainReaderVisitorImpl.class);
    private static final String MISSING_DER_FOR_ROOT_ERROR_MSG = "Missing domain type collection code for %s in root type definition";
    private static final String MISSING_DOMAIN_WRAPPER_DEFINITION_MSG = "Missing domain wrapper definition for dir: %s";
    private static final String FILE_IS_NOT_SUPPORTED_MSG = "File is not supported: %s";
    private static final String PROCESSING_CHILDREN_ERROR_MSG = "There was a problem while processing children: %s";
    private final SnapshotFileHelper fileHelper;
    private final DomainDirectoryAnalyzer domainDirectoryAnalyzer;
    private final DomainDefinitionXmlHelper xmlHelper;
    private DomainImportFilesProcessor domainImportFilesProcessor;
    private String profile;
    private Map<String, DomainWrapper> dirPathAndDomainWrapper = new HashMap<String, DomainWrapper>();

    public DomainReaderVisitorImpl(String profile, SnapshotFileHelper fileHelper, DomainDefinitionXmlHelper domainDefinitionXmlHelper, DomainDirectoryAnalyzer domainDirectoryAnalyzer) {
        this.profile = profile;
        this.fileHelper = fileHelper;
        this.xmlHelper = domainDefinitionXmlHelper;
        this.domainDirectoryAnalyzer = domainDirectoryAnalyzer;
        this.domainImportFilesProcessor = new DomainImportFilesProcessor(new AttributeProcessor(new SnapshotModelConverter<DomainElementAttributesWrapper>(new SnapshotTomlFileParser(), DomainElementAttributesWrapper.class)), new ReferenceProcessor(this.fileHelper, this.xmlHelper), new InfoProcessor(new SnapshotModelConverter<DomainElementWrapper>(new SnapshotTomlFileParser(), DomainElementWrapper.class)));
    }

    @Override
    public Collection<DomainElement> getDomainElements() {
        return this.dirPathAndDomainWrapper.values().stream().filter(DomainWrapper::isRootElement).map(DomainWrapper::getDomainElement).collect(Collectors.toList());
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        if (this.shouldDirectoryBeOmitted(dir)) {
            log.debug("Skipped path: {}", (Object)dir);
            return FileVisitResult.CONTINUE;
        }
        if (this.isGlobalConfigDir(dir.getParent())) {
            log.debug("Processing root level for: {}", (Object)dir);
            this.processRootLevel(dir);
            return FileVisitResult.CONTINUE;
        }
        DomainWrapper domainWrapper = this.findDomainWrapperWithElement(dir).orElseThrow(() -> new IllegalArgumentException(String.format(MISSING_DOMAIN_WRAPPER_DEFINITION_MSG, dir.toString())));
        String directoryName = this.fileHelper.getDirectoryName(dir);
        Optional<DomainTypeCollection> domainTypeCollection = this.xmlHelper.getDomainTypeCollection(domainWrapper.getDomainType(), directoryName);
        domainTypeCollection.ifPresent(dtc -> this.processDirectory(dir, domainWrapper, (DomainTypeCollection)dtc));
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
        if (!this.domainImportFilesProcessor.isFileAcceptable(file)) {
            throw new ImportSnapshotException(String.format(FILE_IS_NOT_SUPPORTED_MSG, file.toString()));
        }
        log.debug("Start processing file: {}", (Object)file);
        this.findDomainWrapperWithElement(file).ifPresent(domainWrapper -> this.domainImportFilesProcessor.process((DomainWrapper)domainWrapper, file));
        return FileVisitResult.CONTINUE;
    }

    private boolean shouldDirectoryBeOmitted(Path dir) {
        return this.isGlobalConfigDir(dir) || this.isPartOfRegionVersionPath(dir);
    }

    private boolean isGlobalConfigDir(Path dir) {
        return dir.endsWith(SnapshotPath.DOMAIN_CONF.getPath());
    }

    private boolean isPartOfRegionVersionPath(Path dir) {
        return dir.endsWith(SnapshotPath.REGIONS_WITH_SEPARATOR.getPath()) || dir.getParent().endsWith(SnapshotPath.REGIONS_WITH_SEPARATOR.getPath()) || dir.getParent().getParent().endsWith(SnapshotPath.REGIONS_WITH_SEPARATOR.getPath());
    }

    private void processRootLevel(Path dir) throws IOException {
        DomainType root = this.xmlHelper.findRoot();
        String directoryName = this.fileHelper.getDirectoryName(dir);
        DomainTypeCollection colTypeDef = this.xmlHelper.getDomainTypeCollection(root, directoryName).orElseThrow(() -> new ImportSnapshotException(String.format(MISSING_DER_FOR_ROOT_ERROR_MSG, directoryName)));
        DomainType domainType = this.xmlHelper.getDomainTypeBasedOnTypeCode(colTypeDef);
        Map<String, DomainWrapper> rootProcessResult = this.processChildrenBasedOnCollectionTypeDefinition(dir, null, colTypeDef, domainType);
        this.dirPathAndDomainWrapper.putAll(rootProcessResult);
    }

    private void processDirectory(Path dir, DomainWrapper domainWrapper, DomainTypeCollection dtc) {
        Map<String, DomainWrapper> processDirResult;
        String collectionTypeCode = dtc.getCollectionTypeCode();
        DomainType domainType = this.xmlHelper.getDomainType(collectionTypeCode);
        try {
            processDirResult = this.processChildrenBasedOnCollectionTypeDefinition(dir, domainWrapper, dtc, domainType);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ImportSnapshotException(String.format(PROCESSING_CHILDREN_ERROR_MSG, dir));
        }
        this.dirPathAndDomainWrapper.putAll(processDirResult);
    }

    private Map<String, DomainWrapper> processChildrenBasedOnCollectionTypeDefinition(Path dir, DomainWrapper parentDomainWrapper, DomainTypeCollection dtc, DomainType domainType) throws IOException {
        HashMap<String, DomainWrapper> result = new HashMap<String, DomainWrapper>();
        result.putAll(this.processDirectChildren(dir, parentDomainWrapper, dtc, domainType));
        result.putAll(this.processChildrenFromRegion(dir, parentDomainWrapper, dtc, domainType));
        log.debug("Created children for dir: {}, children: {}", (Object)dir, result);
        return result;
    }

    private Map<String, DomainWrapper> processChildrenFromRegion(Path dir, DomainWrapper parentDomainWrapper, DomainTypeCollection dtc, DomainType domainType) throws IOException {
        log.debug("Start analyzing possible children directories with region and version of: {}", (Object)dir);
        List<ElementWithRegionVersion> namesFromRegionVersionDirectory = this.domainDirectoryAnalyzer.getNamesFromRegionVersionDirectory(dir);
        log.debug("Found possible children directories with region and version: {}", namesFromRegionVersionDirectory);
        log.debug("Found possible number of children: {}", (Object)namesFromRegionVersionDirectory.size());
        return namesFromRegionVersionDirectory.stream().map(regionElement -> DomainElementFactory.create(this.profile, regionElement.getName(), dtc, regionElement.getRegionCode(), regionElement.getVersion())).collect(Collectors.toMap(domainElement -> PathUtils.removeLastSeparatorFrom(this.resolvePathForRegion(dir, (DomainElement)domainElement)), element -> this.getDomainWrapper(parentDomainWrapper, domainType, (DomainElement)element)));
    }

    private Map<String, DomainWrapper> processDirectChildren(Path dir, DomainWrapper parentDomainWrapper, DomainTypeCollection dtc, DomainType domainType) throws IOException {
        log.debug("Start analyzing direct directories of: {}", (Object)dir);
        List<String> subDirNames = this.domainDirectoryAnalyzer.getSubDirNames(dir);
        log.debug("Found direct children directories: {}", subDirNames);
        log.debug("Found direct number of children: {}", (Object)subDirNames.size());
        return subDirNames.stream().map(subDirName -> DomainElementFactory.create(this.profile, subDirName, dtc)).collect(Collectors.toMap(element -> PathUtils.removeLastSeparatorFrom(dir.resolve(element.getCode())), element -> this.getDomainWrapper(parentDomainWrapper, domainType, (DomainElement)element)));
    }

    private DomainWrapper getDomainWrapper(DomainWrapper domainWrapper, DomainType domainType, DomainElement element) {
        return Optional.ofNullable(domainWrapper).map(parent -> {
            parent.addChildTo(element);
            return DomainWrapper.createWrapperForChildElement(element, domainType);
        }).orElse(DomainWrapper.createWrapperForRootElement(element, domainType));
    }

    private Path resolvePathForRegion(Path dir, DomainElement element) {
        return dir.resolve(SnapshotPath.REGIONS.getPath()).resolve(element.getRegionCode()).resolve(element.getVersionNumber()).resolve(element.getCode());
    }

    private Optional<DomainWrapper> findDomainWrapperWithElement(Path directory) {
        if (directory == null || this.isGlobalConfigDir(directory)) {
            return Optional.empty();
        }
        String key = PathUtils.removeLastSeparatorFrom(directory);
        if (this.dirPathAndDomainWrapper.containsKey(key)) {
            return Optional.of(this.dirPathAndDomainWrapper.get(key));
        }
        return this.findDomainWrapperWithElement(directory.getParent());
    }
}

