/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.core.datasource.snapshot.domain;

import com.google.common.base.Preconditions;
import jakarta.validation.constraints.NotNull;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PathUtils {
    private static final Logger log = LoggerFactory.getLogger(PathUtils.class);
    private static final String SEPARATOR = ".";

    private PathUtils() {
        throw new IllegalStateException("Can't be invoked. This is util class.");
    }

    public static Path createPath(Path path, String other) throws IOException {
        return PathUtils.createPath(path, Paths.get(other, new String[0]));
    }

    public static Path createPath(Path path, Path other) throws IOException {
        return Files.createDirectories(path.resolve(other), new FileAttribute[0]);
    }

    public static Path createFile(Path path, String file) throws IOException {
        return PathUtils.createFile(path, Paths.get(file, new String[0]));
    }

    public static Path createFile(Path path, Path file) throws IOException {
        Files.createDirectories(path, new FileAttribute[0]);
        return Files.createFile(path.resolve(file), new FileAttribute[0]);
    }

    public static Path createFile(Path path) throws IOException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        return Files.createFile(path, new FileAttribute[0]);
    }

    public static Path nameToPath(String name) {
        Preconditions.checkNotNull((Object)name);
        return Paths.get(name.replace(SEPARATOR, File.separator), new String[0]);
    }

    public static boolean containsPath(Path fullPath, Path toCheck) {
        for (Path it : fullPath) {
            if (!it.equals(toCheck)) continue;
            return true;
        }
        return false;
    }

    public static String normalizePath(String path) {
        if (path.endsWith("/")) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static String removeLastSeparatorFrom(Path path) {
        String pathAsString = path.toString();
        if (pathAsString.endsWith(File.separator) || pathAsString.endsWith("/")) {
            return pathAsString.substring(0, pathAsString.length() - 1);
        }
        return pathAsString;
    }

    public static boolean hasFile(Path dirName, String fileName) {
        boolean bl;
        block8: {
            Stream<Path> list = Files.list(dirName);
            try {
                bl = list.anyMatch(f -> f.endsWith(fileName));
                if (list == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (list != null) {
                        try {
                            list.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    return false;
                }
            }
            list.close();
        }
        return bl;
    }

    @NotNull
    public static String getLastElement(Path path) {
        if (path == null) {
            return "";
        }
        Path lastSubPath = path.getFileName();
        if (lastSubPath == null) {
            return "";
        }
        return FilenameUtils.normalizeNoEndSeparator((String)lastSubPath.toString());
    }
}

