/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.core.datasource.snapshot.domain;

import com.moandjiezana.toml.Toml;
import com.moandjiezana.toml.TomlWriter;
import io.higson.runtime.core.datasource.snapshot.domain.PathUtils;
import io.higson.runtime.core.datasource.snapshot.domain.SnapshotFileParser;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.TimeZone;

public class SnapshotTomlFileParser
implements SnapshotFileParser {
    @Override
    public void write(Path path, Object model) throws IOException {
        this.write(path, model, 0);
    }

    @Override
    public void write(Path path, Object model, int indentTablesBy) throws IOException {
        Path filePathForWriter = this.createFilesIfDoesNotExistFor(path);
        try (BufferedWriter writer = Files.newBufferedWriter(filePathForWriter, StandardCharsets.UTF_8, new OpenOption[0]);){
            TomlWriter toml = this.getTomlWriter(indentTablesBy);
            toml.write(model, (Writer)writer);
        }
    }

    private TomlWriter getTomlWriter(int indentTablesBy) {
        TomlWriter.Builder builder = new TomlWriter.Builder().timeZone(TimeZone.getDefault());
        if (indentTablesBy != 0) {
            builder.indentTablesBy(indentTablesBy);
        }
        return builder.build();
    }

    private Path createFilesIfDoesNotExistFor(Path path) throws IOException {
        Path filePathForWriter = path;
        if (!path.toFile().exists()) {
            filePathForWriter = PathUtils.createFile(path);
        }
        return filePathForWriter;
    }

    @Override
    public <T> T createModel(Path path, Class<T> clazz) throws IOException {
        return (T)new Toml().read((Reader)Files.newBufferedReader(path, StandardCharsets.UTF_8)).to(clazz);
    }
}

