/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.core.datasource.snapshot.function;

import io.higson.runtime.function.FunctionType;
import java.nio.file.Path;

public record FunctionMeta(String code, FunctionType type, int id, int implId, Path path, String profile, String region, String version) {
    public static FunctionMetaBuilder builder() {
        return new FunctionMetaBuilder();
    }

    public static class FunctionMetaBuilder {
        private String code;
        private FunctionType type;
        private int id;
        private int implId;
        private Path path;
        private String profile;
        private String region;
        private String version;

        FunctionMetaBuilder() {
        }

        public FunctionMetaBuilder code(String code) {
            this.code = code;
            return this;
        }

        public FunctionMetaBuilder type(FunctionType type) {
            this.type = type;
            return this;
        }

        public FunctionMetaBuilder id(int id) {
            this.id = id;
            return this;
        }

        public FunctionMetaBuilder implId(int implId) {
            this.implId = implId;
            return this;
        }

        public FunctionMetaBuilder path(Path path) {
            this.path = path;
            return this;
        }

        public FunctionMetaBuilder profile(String profile) {
            this.profile = profile;
            return this;
        }

        public FunctionMetaBuilder region(String region) {
            this.region = region;
            return this;
        }

        public FunctionMetaBuilder version(String version) {
            this.version = version;
            return this;
        }

        public FunctionMeta build() {
            return new FunctionMeta(this.code, this.type, this.id, this.implId, this.path, this.profile, this.region, this.version);
        }

        public String toString() {
            return "FunctionMeta.FunctionMetaBuilder(code=" + this.code + ", type=" + this.type + ", id=" + this.id + ", implId=" + this.implId + ", path=" + this.path + ", profile=" + this.profile + ", region=" + this.region + ", version=" + this.version + ")";
        }
    }
}

