/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.core.datasource.snapshot.reader;

import io.higson.runtime.core.datasource.snapshot.reader.SnapshotReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.nio.file.Path;

public class SnapshotDirReader
implements SnapshotReader {
    @Override
    public Reader getReader(File snapshotDir, Path path) {
        try {
            return new FileReader(Path.of(snapshotDir.getPath(), path.toString()).toString());
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Path getPath(Path snapPath, String prefix) {
        return Path.of(snapPath.toString(), prefix);
    }

    @Override
    public boolean exists(Path snapshotDir, Path path) {
        return snapshotDir.resolve(path).toFile().exists();
    }

    @Override
    public String fileSeparator() {
        return File.separator;
    }
}

