/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.core.datasource.snapshot.reader;

import io.higson.runtime.core.datasource.snapshot.reader.SnapshotReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Collections;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotZipReader
implements SnapshotReader {
    private static final Logger log = LoggerFactory.getLogger(SnapshotZipReader.class);
    private final FileSystem fileSystem;

    public SnapshotZipReader(Path snapshot) {
        try {
            this.fileSystem = FileSystems.newFileSystem(snapshot, Collections.emptyMap());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public SnapshotZipReader(File snapshot) {
        this(snapshot.toPath());
    }

    @Override
    public Path getPath(Path snapPath, String prefix) {
        return this.fileSystem.getPath(prefix, new String[0]);
    }

    @Override
    public Reader getReader(File snapshotDir, Path path) {
        return new InputStreamReader(this.getZipEntry(snapshotDir, path.toString()));
    }

    @Override
    public boolean exists(Path snapshotDir, Path path) {
        boolean bl;
        ZipFile zipFile = new ZipFile(snapshotDir.toFile());
        try {
            bl = zipFile.getEntry(path.toString()) != null;
        }
        catch (Throwable throwable) {
            try {
                try {
                    zipFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        zipFile.close();
        return bl;
    }

    @Override
    public String fileSeparator() {
        return this.fileSystem.getSeparator();
    }

    private InputStream getZipEntry(File snapDir, String path) {
        try {
            ZipFile zipFile = new ZipFile(snapDir);
            path = this.normalize(path);
            if (path.startsWith(this.fileSeparator())) {
                path = path.substring(1);
            }
            ZipEntry entry = zipFile.getEntry(path);
            return zipFile.getInputStream(entry);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String normalize(String path) {
        return this.fileSystem.getPath(path, new String[0]).toString();
    }
}

