/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.engine.config;

import io.higson.runtime.core.Properties;
import io.higson.runtime.engine.annotated.PackageList;
import io.higson.runtime.engine.annotated.RepositoryObjectKey;
import io.higson.runtime.engine.annotated.initialization.MethodScannerInitializer;
import io.higson.runtime.engine.annotated.initialization.TypeScannerInitializer;
import io.higson.runtime.engine.config.ParamEngineConfig;
import io.higson.runtime.engine.config.ParamEngineModule;
import io.higson.runtime.engine.config.initialization.ComponentInitializer;
import io.higson.runtime.engine.config.initialization.ComponentInitializerRunner;
import io.higson.runtime.engine.config.initialization.PostConstructInitializer;
import io.higson.runtime.engine.core.function.FunctionCache;
import io.higson.runtime.engine.core.function.FunctionInvoker;
import io.higson.runtime.engine.core.function.FunctionRepository;
import io.higson.runtime.engine.core.matcher.Matcher;
import io.higson.runtime.engine.core.parameter.ParamRepository;
import io.higson.runtime.engine.core.prepared.PreparedParamCache;
import io.higson.runtime.engine.core.type.Type;
import io.higson.runtime.engine.core.type.ValueHolder;
import io.higson.runtime.evict.IdleChecker;
import io.higson.runtime.function.FunctionInvocationInterceptor;
import io.higson.runtime.level.OutputLevelArraySeparator;
import java.util.Arrays;
import java.util.List;

public final class ParamEngineConfigBuilder {
    private final ParamEngineConfig paramEngineConfig;
    private boolean annotationScanEnabled = true;
    private final PackageList packageList = new PackageList();

    private ParamEngineConfigBuilder() {
        this.paramEngineConfig = new ParamEngineConfig();
    }

    public static ParamEngineConfigBuilder paramEngineConfig() {
        return new ParamEngineConfigBuilder();
    }

    public ParamEngineConfig build() {
        if (this.annotationScanEnabled) {
            this.withComponentInitializers(new TypeScannerInitializer(this.packageList), new MethodScannerInitializer(this.packageList));
        }
        this.withComponentInitializers(new PostConstructInitializer());
        return this.paramEngineConfig;
    }

    public ParamEngineConfigBuilder withAnnotationScanDisabled() {
        this.annotationScanEnabled = false;
        return this;
    }

    public ParamEngineConfigBuilder withPackagesToScan(String ... packagesToScan) {
        this.packageList.addAll(packagesToScan);
        return this;
    }

    public ParamEngineConfigBuilder withPackagesToScan(PackageList packagesToScan) {
        this.packageList.addAll(packagesToScan.getPackages());
        return this;
    }

    public ParamEngineConfigBuilder withComponent(Object component) {
        this.paramEngineConfig.addComponent(component);
        return this;
    }

    public ParamEngineConfigBuilder registerModule(ParamEngineModule module) {
        module.registerSelf(this);
        return this;
    }

    public ParamEngineConfigBuilder withParameterRepositories(ParamRepository ... repositories) {
        this.paramEngineConfig.addParameterRepositories(Arrays.asList(repositories));
        return this;
    }

    public ParamEngineConfigBuilder withFunctionRepository(String functionType, int order, FunctionRepository repository) {
        this.paramEngineConfig.addFunctionRepository(new RepositoryObjectKey(functionType, order), repository);
        return this;
    }

    public ParamEngineConfigBuilder withFunctionInvoker(String functionType, FunctionInvoker invoker) {
        this.paramEngineConfig.addFunctionInvoker(functionType, invoker);
        return this;
    }

    public ParamEngineConfigBuilder withFunctionInvoker(String functionType, FunctionInvoker invoker, boolean supported) {
        if (supported) {
            this.paramEngineConfig.addFunctionInvoker(functionType, invoker);
        }
        return this;
    }

    public ParamEngineConfigBuilder withFunctionInvocationInterceptor(FunctionInvocationInterceptor functionInvocationInterceptor) {
        this.paramEngineConfig.addFunctionInvocationInterceptor(functionInvocationInterceptor);
        return this;
    }

    public ParamEngineConfigBuilder withFunctionInvocationInterceptors(List<FunctionInvocationInterceptor> functionInvocationInterceptors) {
        this.paramEngineConfig.addFunctionInvocationInterceptors(functionInvocationInterceptors);
        return this;
    }

    public ParamEngineConfigBuilder withProperties(Properties properties) {
        this.paramEngineConfig.setProperties(properties);
        return this;
    }

    public ParamEngineConfigBuilder withIdleChecker(IdleChecker idleChecker) {
        this.paramEngineConfig.setIdleChecker(idleChecker);
        return this;
    }

    public <T extends ValueHolder> ParamEngineConfigBuilder withType(String code, Type<T> type) {
        this.paramEngineConfig.addType(code, type);
        return this;
    }

    public ParamEngineConfigBuilder withMatcher(String code, Matcher matcher) {
        this.paramEngineConfig.addMatcher(code, matcher);
        return this;
    }

    public ParamEngineConfigBuilder withFunctionCache(FunctionCache functionCache) {
        this.paramEngineConfig.setFunctionCache(functionCache);
        return this;
    }

    public ParamEngineConfigBuilder withParameterCache(PreparedParamCache parameterCache) {
        this.paramEngineConfig.setParameterCache(parameterCache);
        return this;
    }

    public ParamEngineConfigBuilder withInitializationRunner(ComponentInitializerRunner runner) {
        this.paramEngineConfig.setInitializationRunner(runner);
        return this;
    }

    public ParamEngineConfigBuilder withComponentInitializers(ComponentInitializer ... initializers) {
        this.paramEngineConfig.addComponentInitializers(Arrays.asList(initializers));
        return this;
    }

    public ParamEngineConfigBuilder withOutputLevelArraySeparator(OutputLevelArraySeparator arraySeparator) {
        this.paramEngineConfig.setOutputLevelArraySeparator(arraySeparator);
        return this;
    }
}

