/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.engine.types.string;

import io.higson.runtime.engine.annotated.annotations.ParamType;
import io.higson.runtime.engine.core.type.Type;
import io.higson.runtime.engine.types.string.StringHolder;
import jakarta.validation.constraints.NotNull;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;

@ParamType(value="string")
public class StringType
implements Type<StringHolder> {
    @Override
    public String encode(StringHolder holder) {
        return holder.getValue();
    }

    @Override
    public StringHolder decode(String text) {
        return new StringHolder(text);
    }

    @Override
    public StringHolder convert(Object obj) {
        return new StringHolder(obj != null ? StringType.getAsString(obj) : null);
    }

    private static String getAsString(@NotNull Object obj) {
        String string;
        if (obj instanceof Collection) {
            Collection collection = (Collection)obj;
            string = StringType.getCollectionAsString(collection);
        } else {
            string = obj.toString();
        }
        return string;
    }

    private static String getCollectionAsString(Collection<?> collection) {
        return collection.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining(String.valueOf(',')));
    }

    public StringHolder[] newArray(int size) {
        return new StringHolder[size];
    }
}

